<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Blockedips;
use Illuminate\Http\Request;

class BlockedIpsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $blockedips = Blockedips::all();

        return view('admin.blockedips.index', compact('blockedips'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.blockedips.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $blockedips = new Blockedips();
        $blockedips->role_access_block = $request->input('roles');
        $blockedips->ip = $request->input('ip');
        $blockedips->status = $request->input('status');
        // echo '<pre>';print_r($blockedips);exit;

        $blockedips->save();

        return redirect()->route('admin.blockedip.index')->with('success','IP blocked successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
