<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Create Leads</h4>
                        </div>
                        <div class="card-action">
                            <a href="{{ route("admin.leads") }}" class="btn btn-sm btn-primary" role="button">Back</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route("admin.storeleads") }}" method="POST" role="form text-left" class="needs-validation" enctype="multipart/form-data">
                            @csrf
                            <div class="new-user-info">
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="leadowner">Lead Owner: <span class="text-danger">*</span></label>
                                        <select class="form-control" name="leadowner" id="leadowner" required>
                                            @if (count($accounts) > 0)
                                                @foreach ($accounts as $mtaccount)
                                                    <option value="{{ $mtaccount->id }}">{{ $mtaccount->name }}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="firstname">First Name: <span class="text-danger">*</span></label>
                                        <input class="form-control" type="text" placeholder="First Name" id="firstname" name="firstname" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="lastname">Last Name: <span class="text-danger">*</span></label>
                                        <input class="form-control" type="text" placeholder="Last Name" id="lastname" name="lastname" required>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="email">E-Mail: <span class="text-danger">*</span></label>
                                        <input class="form-control" type="email" placeholder="Email" id="email" name="email" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="country">Select Country:</label>
                                        <select class="form-control" name="country" id="country" required>
                                            <option value="">Select Country</option>
                                            @foreach($countries as $country)
                                                <option value="{{ $country->name }}">{{ $country->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="mobile">Mobile: <span class="text-danger">*</span></label>
                                        <input class="form-control" type="text" placeholder="Mobile" id="mobile" name="mobile" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="source">Source: <span class="text-danger">*</span></label>
                                        <input class="form-control" type="text" placeholder="Source" id="source" name="source" required>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="sourceurl">Source URL: <span class="text-danger">*</span></label>
                                        <input class="form-control" type="text" placeholder="Source URL" id="sourceurl" name="sourceurl" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="status">Status:</label>
                                        <select class="form-control" name="status" id="status">
                                            @foreach($leadstatus as $status)
                                                <option value="{{$status->name}}">{{$status->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="note">Comment:</label>
                                        <input class="form-control" type="text" placeholder="Comment" id="note" name="note">
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-sm btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
