<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Edit Leads</h4>
                        </div>
                        <div class="card-action">
                            <a href="{{ route("admin.leads") }}" class="btn btn-sm btn-primary" role="button">Back</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route("admin.leadsupdate") }}" method="POST" role="form text-left" class="needs-validation" enctype="multipart/form-data">
                            @csrf
                            <div class="new-user-info">
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="email">E-Mail: <span class="text-danger">*</span></label>
                                        <input class="form-control" type="email" value="{{ $leaddata->email }}" placeholder="Email" id="email" name="email" required>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="leadowner">Lead Owner: <span class="text-danger">*</span></label>
                                        <select class="form-control" name="leadowner" id="leadowner" required>
                                            @if (count($accounts) > 0)
                                                @foreach ($accounts as $mtaccount)
                                                <option value="{{ $mtaccount->id }}"
                                                    @if ($leaddata->leadowner == $mtaccount->id) selected @endif>{{ $mtaccount->name }}
                                                </option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="status">Status:</label>
                                        <select class="form-control" name="status" id="status">
                                            @foreach($leadstatus as $status)
                                                <option value="{{$status->name}}" @if($leaddata->status == $status->name) selected @endif>{{ $status->name }}</option>
                                            @endforeach
                                        </select>
                                        <input type="hidden" name="id" value="{{ $id }}">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="note">Comment:</label>
                                        <input class="form-control" type="text" placeholder="Comment" id="note" name="note" value="{{ $leaddata->note }}">
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-sm btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Add Appointments</h4>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('admin.storeAppointment') }}" method="POST" role="form text-left" class="needs-validation" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="lead_id" value="{{ $leaddata->id }}">
                            <div class="new-user-info">
                                <div class="row">
                                    <div class="form-group col-md-3">
                                        <label class="form-label" for="appointment_description">Appointment Note: <span class="text-danger">*</span></label>
                                        <input class="form-control" type="text" placeholder="Appointment Note" id="appointment_description" name="appointment_description" required>
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label class="form-label" for="leadowner">Date: <span class="text-danger">*</span></label>
                                        <input class="form-control" type="date" placeholder="Date" id="appointment_date" name="appointment_date" required>
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label class="form-label" for="leadowner">Time: <span class="text-danger">*</span></label>
                                        <input class="form-control" type="time" placeholder="Time" id="appointment_time" name="appointment_time" required>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-sm btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Appointments</h4>
                        </div>
                    </div>
                    <div class="card-body px-0">
                        <div class="table-responsive">
                            <table class="table table-bordered" role="grid" data-toggle="data-table">
                                <thead>
                                    <tr class="ligth">
                                        <th style="text-align: center">Appointment Note</th>
                                        <th style="text-align: center">Appointment Date</th>
                                        <th style="text-align: center">Appointment Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($leaddata->appointments as $appointment)
                                        <tr data-entry-id="{{ $appointment->id }}">
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $appointment->appointment_note ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $appointment->appointment_date ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $appointment->appointment_time ?? '' }}</p>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
