<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Create User</h4>
                        </div>
                        <div class="card-action">
                            <a href="{{ route("admin.users.index") }}" class="btn btn-sm btn-primary" role="button">Back</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route("admin.users.store") }}" method="POST" role="form text-left" class="needs-validation" enctype="multipart/form-data">
                            @csrf
                            <div class="new-user-info">
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="name">Name: <span class="text-danger">*</span></label>
                                        <input class="form-control" value="{{ old('name', isset($user) ? $user->name : '') }}" type="text" placeholder="User Name" id="name" name="name" required>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="email">E-Mail: <span class="text-danger">*</span></label>
                                        <input class="form-control" value="{{ old('email', isset($user) ? $user->email : '') }}" type="email" placeholder="User Email" id="email" name="email" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="mobile">Mobile: <span class="text-danger">*</span></label>
                                        <input class="form-control" value="{{ old('mobile', isset($user) ? $user->mobile : '') }}" type="text" placeholder="Mobile" id="mobile" name="mobile" required>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="country">Country:</label>
                                        <select class="form-control" name="country" id="country">
                                            <option value="">Select Country</option>
                                            @foreach($countries as $country)
                                                <option value="{{ $country->name }}">{{ $country->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="password">Password:</label>
                                        <input class="form-control" value="" type="password" placeholder="Password" id="password" name="password">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="afid">Select Affiliate:</label>
                                        <select class="form-control" name="afid" id="afid" >
                                            <option value="">Select Affiliate</option>
                                            @if(count($affiliates)>0)
                                                @foreach($affiliates as $affiliate)
                                                    <option value="{{ $affiliate->id }}">{{ $affiliate->name }}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-sm btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
