<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Withdraw Amount</h4>
                        </div>
                        <div class="card-action">
                            <a href="{{ route("admin.withdrawlist") }}" class="btn btn-sm btn-primary" role="button">Back</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route("admin.storemanualwithdraw") }}" method="POST" role="form text-left" class="needs-validation" enctype="multipart/form-data">
                            @csrf
                            <div class="new-user-info">
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="mt4account">Select MT5account <span class="text-danger">*</span></label>
                                        <select class="form-control" name="mt4account" id="mt4account">
                                            @if(count($accounts)>0)
                                                @foreach($accounts as $mtaccount)
                                                    <option value="{{$mtaccount->loginid}}">{{$mtaccount->loginid}}  ({{$mtaccount->name}})({{$mtaccount->email}})</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="amount">Amount <span class="text-danger">*</span></label>
                                        <input class="form-control" type="number" placeholder="Amount" id="amount" name="amount" min="0" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="description">Description</label>
                                        <textarea class="form-control" name="description" id="description" cols="30" rows="10"></textarea>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-sm btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
