<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\MassDestroyProductRequest;
use App\Http\Requests\UpdateProductRequest;
use App\Models\Internaltransfer;
use App\Models\Mtaccount;
use App\Models\Product;
use App\Models\Setting;
use App\Models\User;
use App\Models\Withdraw;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Validator;

class WithdrawController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $accounts = Withdraw::where('userid', Auth::user()->id)->get();

        return view('admin.withdraw.index', compact('accounts'));
    }

    public function adminindex()
    {
        // abort_unless(\Gate::allows('product_access'), 403);
        $checkadmin = Gate::allows('permission_create');
        if ($checkadmin == true) {
            // $accounts = Mtaccount::get();
            $accounts = DB::table('withdraw')
                ->join('users', 'withdraw.userid', '=', 'users.id')
                ->select('users.name', 'users.email', 'withdraw.*')
                ->get();
        } elseif ($checkadmin == false && Auth::user()->affiliate == '1') {
            $accounts = DB::table('withdraw')
                ->join('users', 'withdraw.userid', '=', 'users.id')
                ->select('users.name', 'users.email', 'withdraw.*')
                ->where('users.afid', Auth::user()->id)
                ->get();
        } else {
            abort(403);
        }


        return view('admin.withdraw.adminindex', compact('accounts'));
    }

    public function editwithdraw($id)
    {
        // abort_unless(\Gate::allows('product_access'), 403);
        $cid = $id;

        return view('admin.withdraw.approve', compact('cid'));
    }

    public function withdrawapproved(Request $request)
    {
        //$this->makeconnection();

        $docdata = Withdraw::where('id', $request->id)->first();
        $comment = 'withdraw';
        //$url = $this->apicall.'MAKE_WITHDRAW_BALANCE?MT4Account='.$docdata->mt4account.'&Amount='.$docdata->amount.'&Comment='.$comment.'&ManagerIndex='.$this->manager;


        $amountw = '-' . $docdata->amount;
        $postfields = array(
            'method' => 'Deposit',
            'key' => '0001',
            'array' =>
            array(
                0 =>
                array(
                    'index' => 0,
                    'accountID' => $docdata->mt4account,
                    'comment' => $comment,
                    'amount' => $amountw,
                ),
            ),
        );
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "http://jenya.securedns.us:3001/capitalmanageinv",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($postfields),
            CURLOPT_HTTPHEADER => array(
                "Content-Type: text/plain"
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $getresult = json_decode($response);

        if ($getresult->systemErrorStatus == '') {
            Withdraw::where('id', $request->id)->update(array(
                'description'     => $request->description,
                'status'     => $request->status,
            ));
        }

        return redirect('admin/withdrawlist');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $accounts = Mtaccount::where('userid', Auth::user()->id)->get();
        $countries = DB::table('countries')->get();
        return view('admin.withdraw.create', compact('accounts', 'countries'));
    }

    public function internaltransfer()
    {
        // abort_unless(\Gate::allows('product_create'), 403);
        $accounts = Internaltransfer::where('userid', Auth::user()->id)->get();
        return view('admin.withdraw.transferlist', compact('accounts'));
    }

    public function createtransfer()
    {
        // abort_unless(\Gate::allows('product_create'), 403);
        $accounts = Mtaccount::where('userid', Auth::user()->id)->get();
        return view('admin.withdraw.transfer', compact('accounts'));
    }

    public function storetransfer(Request $request)
    {
        //	$this->makeconnection();
        $validator = Validator::make($request->all(), [
            'fromaccount' => 'required',
            'toaccount' => 'required'
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }


        if ($request->fromaccount == $request->toaccount) {
            return redirect()->back()->withErrors(['transfer not allowed in same account.']);
        }
        $url = 'http://api.tradeactive.com/mt5demo/api/api.php?MODE=FetchUser';
        $postdata = array();
        $postdata['LOGIN'] = $request->fromaccount;
        $option = array(
            'Content-Type:application/json'
        );

        $ch = curl_init(str_replace(' ', '', $url));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $option);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true); // Specify the request method as POST
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postdata));
        $getallw = curl_exec($ch);
        $getuserdata = json_decode($getallw);
        $ubalnc = $getuserdata->response->Balance;
        // 	echo $ubalnc;exit;
        if ($request->amount > $ubalnc) {
            return redirect()->back()->withErrors(['not enough balance.']);
            return redirect()->back();
        } else {

            $commentw = 'transfer to ' . $request->toaccount;
            $commentd = 'transfer from ' . $request->fromaccount;
            $comntd = str_replace(' ', '-', $commentd);
            $amountw = '-' . $request->amount;

            $postfields = array();
            $postfields['LOGIN'] = $request->fromaccount;
            $postfields['TYPE'] = 2;
            $postfields['BALANCE'] = $amountw;
            $postfields['COMMENT'] = $commentw;
            $postfields['CHECK_MARGIN'] = '1';
            $apiurl = 'http://api.tradeactive.com/mt5demo/api/api.php?MODE=Withdraw';
            $option = array(
                'Content-Type: application/json'
            );

            $ch = curl_init($apiurl);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $option);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true); // Specify the request method as POST
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postfields));
            $result = curl_exec($ch);
            $getresult = json_decode($result);
            // echo '<pre>';print_r($getresult);exit;
            if ($getresult->status !== '') {
                $postfields2 = array();
                $postfields2['LOGIN'] = $request->toaccount;
                $postfields2['TYPE'] = 2;
                $postfields2['COMMENT'] = $comntd;
                $postfields2['BALANCE'] = $request->amount;
                $postfields2['CHECK_MARGIN'] = '1';
                $apiurl2 = 'http://api.tradeactive.com/mt5demo/api/api.php?MODE=Deposit';
                $option2 = array(
                    'Content-Type: application/json'
                );
                // echo '<pre>';print_r($postfields2);exit;
                $ch2 = curl_init($apiurl2);
                curl_setopt($ch2, CURLOPT_HTTPHEADER, $option2);
                curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch2, CURLOPT_POST, true); // Specify the request method as POST
                curl_setopt($ch2, CURLOPT_POSTFIELDS, json_encode($postfields2));
                $result2 = curl_exec($ch2);
                $getresult2 = json_decode($result2);
                // echo '<pre>';print_r($postfields2);exit;

                if ($getresult2->status !== '') {
                    $adduser = array();
                    $adduser['fromaccount'] = $request->fromaccount;
                    $adduser['toaccount'] = $request->toaccount;
                    $adduser['userid'] = Auth::user()->id;
                    $adduser['amount'] = $request->amount;
                    $adduser['notes'] = $request->description;

                    Internaltransfer::create($adduser);

                    return redirect()->back()->with('success', 'Your Transfer Done Successfully.');
                }
            }
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $settings = Setting::where('id', '2')->get();
        // echo '<pre>';print_r($settings);exit;
        if ($settings['0']['status'] == '1') {
            $url = 'http://api.tradeactive.com/mt5demo/api/api.php?MODE=FetchUser';
            $postdata = array();
            $postdata['LOGIN'] = $request->mt4account;
            $option = array(
                'Content-Type:application/json'
            );

            $ch = curl_init(str_replace(' ', '', $url));
            curl_setopt($ch, CURLOPT_HTTPHEADER, $option);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true); // Specify the request method as POST
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postdata));
            $getallw = curl_exec($ch);
            curl_close($ch);
            $getuserdata = json_decode($getallw);
            if (!isset($getuserdata->response->Balance)) {
                return redirect()->back()->withErrors(['account not found.']);
            }

            $getuserdata2 = $getuserdata->response->Balance;
            if ($request->amount > $getuserdata2) {
                return redirect()->back()->withErrors(['not enough balance.']);
            }
            // return redirect()->back();
            $checkde = Mtaccount::where('loginid', $request->mt4account)->first();
            $getcountry = User::where('id', $checkde->userid)->first();
            $comnt = 'manual-withdraw';

            //  $url2 = $this->apicall.'MAKE_WITHDRAW_BALANCE?MT4Account='.$request->mt4account.'&Amount='.$request->amount.'&Comment='.$comnt.'&ManagerIndex='.$this->manager;

            $amountw = '-' . $request->amount;

            $urlw = 'http://api.tradeactive.com/mt5demo/api/api.php?MODE=Withdraw';
            $postdata1 = array();
            $postdata1['LOGIN'] = $request->mt4account;
            $postdata1['TYPE'] = 2;
            $postdata1['BALANCE'] = $amountw;
            $postdata1['COMMENT'] = 'manual-withdraw';
            $postdata1['CHECK_MARGIN'] = '1';
            $option = array(
                'Content-Type:application/json'
            );
            $ch1 = curl_init(str_replace(' ', '', $urlw));
            curl_setopt($ch1, CURLOPT_HTTPHEADER, $option);
            curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch1, CURLOPT_POST, true); // Specify the request method as POST
            curl_setopt($ch1, CURLOPT_POSTFIELDS, json_encode($postdata1));
            $getallw1 = curl_exec($ch1);
            curl_close($ch1);
            $getuserdata1 = json_decode($getallw1);
            // echo '<pre>';print_r($getuserdata1);exit;
            if ($getuserdata1->status == 'success') {

                $data = $request->all();
                $adduser = array();
                $adduser['mt4account'] = $data['mt4account'];
                $adduser['benename'] = '--';
                $adduser['country'] = $getcountry->country;
                $adduser['bankname'] = '--';
                $adduser['bankaddress'] = '--';
                $adduser['bankaccount'] = '--';
                $adduser['swiftcode'] = '--';
                $adduser['userid'] = $checkde->userid;
                $adduser['amount'] = $data['amount'];
                $adduser['clientnote'] = '-';
                $adduser['description'] = $data['description'];
                $adduser['status'] = '1';

                $product = Withdraw::create($adduser);
            }
            return redirect()->route('admin.withdraw.index')->with('success', 'Withdraw amount successfully');
        } else { 
            $url = 'http://api.tradeactive.com/mt5demo/api/api.php?MODE=FetchUser';
            $postdata = array();
            $postdata['LOGIN'] = $request->mt4account;
            $option = array(
                'Content-Type:application/json'
            );

            $ch = curl_init(str_replace(' ', '', $url));
            curl_setopt($ch, CURLOPT_HTTPHEADER, $option);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true); // Specify the request method as POST
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postdata));
            $getallw = curl_exec($ch);
            $getuserdata = json_decode($getallw);
            // dd($getuserdata->response->Balance);
            if (!isset($getuserdata->response->Balance)) {
                return redirect()->back()->withErrors(['account not found.']);
            }
            $ubalnc = $getuserdata->response->Balance;

            if ($request->amount > $ubalnc) {
                return redirect()->back()->withErrors(['not enough balance.']);
                return redirect()->back();
            }

            $data = $request->all();
            $adduser = array();
            $adduser['mt4account'] = $data['mt4account'];
            $adduser['benename'] = $data['benename'];
            $adduser['country'] = $data['country'];
            $adduser['bankname'] = $data['bankname'];
            $adduser['bankaddress'] = $data['bankaddress'];
            $adduser['bankaccount'] = $data['accountno'];
            $adduser['swiftcode'] = $data['swiftcode'];
            $adduser['userid'] = Auth::user()->id;
            $adduser['amount'] = $data['amount'];
            $adduser['clientnote'] = $data['description'];

            $product = Withdraw::create($adduser);

            return redirect()->route('admin.withdraw.index')->with('success', 'Withdraw request send successfully');
        }
    }

    public function manualwithdraw()
    {
        $checkadmin = Gate::allows('permission_create');
        if ($checkadmin == true) {
            // $accounts = Mtaccount::get();
            $accounts = DB::table('mtaccount')
                ->join('users', 'mtaccount.userid', '=', 'users.id')
                ->select('users.name', 'users.email', 'mtaccount.*')
                ->get();
        } elseif ($checkadmin == false && Auth::user()->affiliate == '1') {
            $accounts = DB::table('mtaccount')
                ->join('users', 'mtaccount.userid', '=', 'users.id')
                ->select('users.name', 'users.email', 'mtaccount.*')
                ->where('users.afid', Auth::user()->id)
                ->get();
        } else {
            abort(403);
        }

        return view('admin.withdraw.manual', compact('accounts'));
    }

    public function storemanualwithdraw(Request $request)
    {
        $postfields3 = array(
            'method' => 'GetUserByLogin',
            'key' => '0001',
            'array' =>
            array(
                0 =>
                array(
                    'index' => 0,
                    'accountID' => $request->mt4account
                ),
            ),
        );
        $curl3 = curl_init();
        curl_setopt_array($curl3, array(
            CURLOPT_URL => "http://jenya.securedns.us:3001/capitalmanageinv",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($postfields3),
            CURLOPT_HTTPHEADER => array(
                "Content-Type: text/plain"
            ),
        ));
        $response3 = curl_exec($curl3);
        curl_close($curl3);
        $getresult3 = json_decode($response3);
        $ubalnc = $getresult3->array[0]->pltAccount->balance;

        if ($request->amount > $ubalnc) {
            return redirect()->back()->withErrors(['not enough balance.']);
            return redirect()->back();
        }
        $checkde = Mtaccount::where('loginid', $request->mt4account)->first();
        $getcountry = User::where('id', $checkde->userid)->first();
        $comnt = 'manual-withdraw';

        //  $url2 = $this->apicall.'MAKE_WITHDRAW_BALANCE?MT4Account='.$request->mt4account.'&Amount='.$request->amount.'&Comment='.$comnt.'&ManagerIndex='.$this->manager;

        $amountw = '-' . $request->amount;
        $postfields = array(
            'method' => 'Deposit',
            'key' => '0001',
            'array' =>
            array(
                0 =>
                array(
                    'index' => 0,
                    'accountID' => $request->mt4account,
                    'comment' => $comnt,
                    'amount' => $amountw,
                ),
            ),
        );
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "http://jenya.securedns.us:3001/capitalmanageinv",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($postfields),
            CURLOPT_HTTPHEADER => array(
                "Content-Type: text/plain"
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $getresult = json_decode($response);

        if ($getresult->systemErrorStatus == '') {


            $data = $request->all();
            $adduser = array();
            $adduser['mt4account'] = $data['mt4account'];
            $adduser['benename'] = '--';
            $adduser['country'] = $getcountry->country;
            $adduser['bankname'] = '--';
            $adduser['bankaddress'] = '--';
            $adduser['bankaccount'] = '--';
            $adduser['swiftcode'] = '--';
            $adduser['userid'] = $checkde->userid;
            $adduser['amount'] = $data['amount'];
            $adduser['clientnote'] = '-';
            $adduser['description'] = $data['description'];
            $adduser['status'] = '1';

            $product = Withdraw::create($adduser);
        }
        return redirect()->route('admin.withdrawlist');
    }

    /**
     * Display the specified resource.
     */
    public function show(Product $product)
    {
        abort_unless(Gate::allows('product_show'), 403);

        return view('admin.products.show', compact('product'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Product $product)
    {
        return view('admin.products.edit', compact('product'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateProductRequest $request, Product $product)
    {
        $product->update($request->all());

        return redirect()->route('admin.products.index');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Product $product)
    {
        abort_unless(Gate::allows('product_delete'), 403);

        $product->delete();

        return back();
    }

    public function massDestroy(MassDestroyProductRequest $request)
    {
        Product::whereIn('id', request('ids'))->delete();

        return response(null, 204);
    }
}
