<?php

namespace App\Http\Controllers;

use App\Models\AffiliateKey;
use App\Models\Apilogs;
use App\Models\Deposit;
use App\Models\Documents;
use App\Models\Leads;
use App\Models\Mtaccount;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Hash;

class ApiController extends Controller
{
    public function getsubsb(Request $request)
    {
        $adduser = array();
        $adduser['description'] = $request;
        Apilogs::create($adduser);
        $getd = file_get_contents("php://input");
        $getdata = json_decode($getd);
        //echo '<pre>';print_r($getdata);exit;
        if ($getdata->levelName == 'basic-kyc-level' && $getdata->reviewResult->reviewAnswer == 'GREEN') {
            User::where('id', $getdata->externalUserId)->update(array(
                'sumsuba' =>  '1'
            ));
            $appurl = 'https://api.sumsub.com/resources/applicants/' . $getdata->applicantId . '/requiredIdDocsStatus';

            $ts = time();
            $url = '/resources/applicants/' . $getdata->applicantId . '/requiredIdDocsStatus';
            $string = $ts . 'GET' . $url;
            $sign =  hash_hmac('sha256', $string, 'Z7cqztk7DkmqbaCZwXJJrFhaSlaf3axq');

            $option = array(
                'Content-Type:application/json',
                'X-App-Token: sbx:jfqPDIfUuQIEfElxz54bNqwK.WwCw0b18S3tvUo6NvNNdHYHpazxJPZ5x',
                'X-App-Access-Sig: ' . $sign,
                'X-App-Access-Ts: ' . $ts
            );

            $ch = curl_init($appurl);
            //curl_setopt( $ch, CURLOPT_POSTFIELDS,  array() );
            curl_setopt($ch, CURLOPT_HTTPHEADER, $option);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $result = curl_exec($ch);
            curl_close($ch);
            $finaldata = json_decode($result);
            $imagesid = $finaldata->IDENTITY->imageIds;
            if (!empty($imagesid)) {
                foreach ($imagesid as $imageid) {
                    $appurl1 = 'https://api.sumsub.com/resources/inspections/' . $getdata->inspectionId . '/resources/' . $imageid;
                    $ts1 = time();
                    $url1 = '/resources/inspections/' . $getdata->inspectionId . '/resources/' . $imageid;
                    $string1 = $ts1 . 'GET' . $url1;
                    $sign1 =  hash_hmac('sha256', $string1, 'Z7cqztk7DkmqbaCZwXJJrFhaSlaf3axq');
                    //dd($sign);

                    $option1 = array(
                        'Content-Type:application/json',
                        'X-App-Token: sbx:jfqPDIfUuQIEfElxz54bNqwK.WwCw0b18S3tvUo6NvNNdHYHpazxJPZ5x',
                        'X-App-Access-Sig: ' . $sign1,
                        'X-App-Access-Ts: ' . $ts1
                    );

                    $ch1 = curl_init($appurl1);
                    //curl_setopt( $ch, CURLOPT_POSTFIELDS,  array() );
                    curl_setopt($ch1, CURLOPT_HTTPHEADER, $option1);
                    curl_setopt($ch1, CURLOPT_RETURNTRANSFER, true);
                    $result1 = curl_exec($ch1);
                    /*$imageInfo1 = getimagesizefromstring($result1);
                        //$imagePath = '/path/to/save/image.jpg'; // Set the desired path and filename to save the image
                        if($imageInfo1['mime'] == 'image/jpeg'){
                        $ext = 'jpg';
                        }else{
                        $ext = 'png';
                        }
                        $imagenm = $imageid.'.png';
                    */
                    $mimetype = curl_getinfo($ch1, CURLINFO_CONTENT_TYPE);

                    if ($mimetype == 'image/jpeg') {
                        $ext = 'jpg';
                    } elseif ($mimetype == 'image/png') {
                        $ext = 'png';
                    } elseif ($mimetype == 'application/pdf') {
                        $ext = 'pdf';
                    } elseif ($mimetype == 'video/webm') {
                        $ext = 'webm';
                    } else {
                        $ext = 'png';
                    }
                    $imagenm = $imageid . '.' . $ext;
                    //$imagePath = public_path() . '/images/sumsub/'.$getdata->externalUserId.'/'.$imagenm;
                    $save_path = public_path() . '/documents/' . $getdata->externalUserId;
                    $save_path1 = $save_path . '/' . $imagenm;
                    File::makeDirectory($save_path, $mode = 0777, true, true);
                    file_put_contents($save_path1, $result1);
                    curl_close($ch1);
                    $checknodouble = Documents::where('userid', $getdata->externalUserId)->where('identity', $imagenm)->count();
                    if ($checknodouble == 0) {
                        $imageUploadpoa = new Documents();
                        $imageUploadpoa->userid = $getdata->externalUserId;
                        $imageUploadpoa->identity = $imagenm;
                        $imageUploadpoa->status = '1';
                        $imageUploadpoa->type = '1';
                        $imageUploadpoa->extension = $ext;
                        $imageUploadpoa->save();
                    }
                }
                return "true";
            }
        }
    }

    public function autologin(Request $request)
    {
        //Auth::loginUsingId(2);
        $parts = parse_url($_SERVER['REQUEST_URI']);
        $email = '';
        $userget = '';
        if (!empty($parts['query'])) {
            parse_str($parts['query'], $query);

            if (!empty($query['email'])) {
                $email = $query['email'];
                $userget = User::select('id')->where('email', $email)->first();
            }
        }
        if (empty($userget)) {
            $array = array('status' => false, 'error' => 'no user found');
            return response()->json($array);
        }
        if (empty($email) && empty($userget)) {
            $array = array('status' => false, 'error' => 'token invalid');
            return response()->json($array);
        } else {
            Auth::loginUsingId($userget->id);
            return redirect('admin');
        }
    }

    public function getleads(Request $request)
    {
        // $apikey = 'T9fFGrpR2XoZ6wF';
        $affiliatekeys = AffiliateKey::where('api_key',$request->key)->first();
        $parts = parse_url($_SERVER['REQUEST_URI']);
        $key = $source = $status = $start = $end = '';
        if (!empty($parts['query'])) {
            parse_str($parts['query'], $query);
            if (empty($query['key'])) {
                $array = array('status' => false, 'error' => 'key required');
                return response()->json($array);
            }
            if (!empty($query['key'])) {
                $key = $query['key'];
            }

            $source = $query['source'];
            if (!empty($query['status'])) {
                $status = $query['status'];
            }
            if (!empty($query['start_date'])) {
                $start = $query['start_date'];
            }
            if (!empty($query['end_date'])) {
                $end = $query['end_date'];
            }
        }
        if (empty($source)) {
            $array = array('status' => false, 'error' => 'invalid parameters');
            return response()->json($array);
        }
        if ($key != $affiliatekeys->api_key) {
            $array = array('status' => false, 'error' => 'invalid API key');
            return response()->json($array);
        } else {

            $leads = Leads::select('id as lead_no', 'firstname', 'lastname', 'email', 'password', 'country', 'mobile', 'source', 'status', 'created_at as date', 'note as comment')->where('source', $source)->get();
            if (count($leads) == 0) {
                $array = array('status' => false, 'error' => 'no lead found');
                return response()->json($array);
            }
            if (!empty($status)) {
                $leads = Leads::select('id as lead_no', 'firstname', 'lastname', 'email', 'password', 'country', 'mobile', 'source', 'status', 'created_at as date', 'note as comment')->where('source', $source)->where('status', $status)->get();
            }
            if (!empty($start) && !empty($end) && !empty($status)) {
                $sdate = date('Y-m-d 00:00:00', strtotime($start));
                $edate = date('Y-m-d 23:59:59', strtotime($end));
                $leads = Leads::select('id as lead_no', 'firstname', 'lastname', 'email', 'password', 'country', 'mobile', 'source', 'status', 'created_at as date', 'note as comment')->where('source', $source)->where('status', $status)->whereBetween('created_at', [$sdate, $edate])->get();
            }
            if (!empty($start) && !empty($end) && empty($status)) {
                $sdate = date('Y-m-d 00:00:00', strtotime($start));
                $edate = date('Y-m-d 23:59:59', strtotime($end));
                $leads = Leads::select('id as lead_no', 'firstname', 'lastname', 'email', 'password', 'country', 'mobile', 'source', 'status', 'created_at as date', 'note as comment')->where('source', $source)->whereBetween('created_at', [$sdate, $edate])->get();
            }
            return response()->json(array('status' => true, 'response' => $leads));
        }
    }
    public function createlead(Request $request)
    {
        $affiliatekeys = AffiliateKey::where('api_key',$request->key)->first();
        $source = AffiliateKey::where('source',$request->source)->first();
        // echo $affiliatekeys;exit;
        if (!$affiliatekeys || !$source || $affiliatekeys->source !== $request->source || $affiliatekeys->api_key !== $request->key) {
            $array = array('status' => false, 'error' => 'Invalid API Key or Source');
            return response()->json($array);
        } else {
            $geid = str_replace('AF-', '', $request->officepromocode);
            $finalafid = str_replace(' ', '', $request->officepromocode);
            $checkuserc = User::where('email', $request->email)->count();
            if ($checkuserc > 0) {
                $array = array('status' => false, 'error' => 'user already exist');
                return response()->json($array);
            }
            $checkuserc1 = User::where('promo', $finalafid)->first();
            if (!empty($checkuserc1)) {
                $array = array('status' => false, 'error' => 'promo code not exist');
                return response()->json($array);
            }

            $leadschec = Leads::where('email', $request->email)->count();
            if ($leadschec > 0) {
                $array = array('status' => false, 'error' => 'email already exist');
                return response()->json($array);
            }
            $checkcode = '';
            $adduser = array();
            $adduser['name'] = $request->first_name . ' ' . $request->last_name;
            $adduser['email'] = $request->email;
            $adduser['mobile'] = $request->mobile_num;
            $adduser['country'] = $request->country;
            $adduser['password'] = Hash::make($request->password);
            $adduser['mypass'] = base64_encode($request->password);
            $adduser['status'] = '2';
            $adduser['walt'] = '1';
            $adduser['depositallow'] = '1';
            $adduser['afid'] =  $checkuserc1->id ?? '';
            $newuser = User::create($adduser);
            $newuser->roles()->sync(2);
            $inputdata = array();
            $inputdata['firstname'] = $request->first_name ?? '';
            $inputdata['lastname'] = $request->last_name ?? '';
            $inputdata['email'] = $request->email;
            $inputdata['password'] = $request->password;
            $inputdata['country'] = $request->country ?? '';
            $inputdata['mobile'] = $request->mobile_num ?? '';
            $inputdata['leadowner'] = $checkuserc1->id ?? '';
            $inputdata['source'] = $request->source;
            $inputdata['sourceurl'] = $request->sourceurl ?? '';
            $inputdata['note'] = $request->note ?? '';
            $inputdata['status'] = $request->status;
            if($inputdata['email'] =="" || $inputdata['password'] == "" || $inputdata['source'] == "" || $inputdata['status'] == ""){
                $array = array('status' => false, 'error' => 'Fields are required');
                return response()->json($array);
            }else {
                if ($addlead = Leads::create($inputdata)) {
                    $mainpass = $this->random_password(2, 2, 3, 2);
                    $invepass = $this->random_password(2, 2, 3, 2);
                    $groupname = 'real\\real';
                    $userdetail['LOGIN'] = '';
                    $userdetail['PASS_MAIN'] = $mainpass;
                    $userdetail['PASS_INVESTOR'] = $invepass;
                    $userdetail['RIGHTS'] = 3;
                    $userdetail['GROUP'] = $groupname;
                    $userdetail['NAME'] = $request->first_name . ' ' . $request->last_name;
                    $userdetail['COMPANY'] = '';
                    $userdetail['LANGUAGE'] = '';
                    $userdetail['COUNTRY'] = $request->country;
                    $userdetail['CITY'] = '';
                    $userdetail['STATE'] = '';
                    $userdetail['ZIPCODE'] = '';
                    $userdetail['ADDRESS'] = '';
                    $userdetail['PHONE'] = $request->mobile_num;
                    $userdetail['EMAIL'] = $request->email;
                    $userdetail['COMMENT'] = '';
                    $userdetail['PASS_PHONE'] = '';
                    $userdetail['LEVERAGE'] = 100;
                    $userdetail['AGENT'] = '';
                    //$name = Auth::user()->name;
                    $apiurl = 'http://api.tradeactive.com/mt5demo/api/api.php?MODE=AddUser';
                    // dd($url);
                    $option = array(
                        'Content-Type:application/json'
                    );

                    $ch = curl_init($apiurl);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $option);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_POST, true); // Specify the request method as POST
                    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($userdetail));
                    $result = curl_exec($ch);
                    $getresult = json_decode($result);

                    if ($getresult->status !== '') {
                        $adduser['userid'] = $newuser->id;;
                        $adduser['loginid'] = $getresult->login;
                        $adduser['mainpass'] = $mainpass;
                        $adduser['leverage'] = 100;
                        $adduser['groupname'] =  "real\\real";

                        $product = Mtaccount::create($adduser);
                    }
                    return response()->json(['status' => true, 'lead_no' => $addlead->id]);
                } else {
                    $array = array('status' => false);
                    return response()->json($array);
                }
            }
        }
    }

    public function getleadstatus(Request $request)
    {
        // $apikey = 'T9fFGrpR2XoZ6wF';
        $affiliatekeys = AffiliateKey::where('api_key',$request->key)->first();
        $parts = parse_url($_SERVER['REQUEST_URI']);
        $key = $leadno = $source = '';
        if (!empty($parts['query'])) {
            parse_str($parts['query'], $query);
            $key = $query['key'];
            if (!empty($query['lead_no'])) {
                $leadno = $query['lead_no'];
            }
            if (!empty($query['source'])) {
                $source = $query['source'];
            }
        }

        if (empty($leadno) || empty($affiliatekeys->source)) {
            $array = array('status' => false, 'error' => 'invalid parameters');
            return response()->json($array);
        }

        if ($key != $affiliatekeys->api_key) {
            $array = array('status' => false, 'error' => 'invalid API key');
            return response()->json($array);
        } else {

            $leads = Leads::select('status', 'id as lead_no', 'email')->where('source', $source)->where('id', $leadno)->first();
            if (empty($leads)) {
                $array = array('status' => false, 'error' => 'no leads found');
                return response()->json($array);
            }
            return response()->json(array('status' => true, 'response' => $leads));
        }
    }

    public function random_password($lower, $upper, $digits, $special_characters)
    {
        $lower_case = "abcdefghijklmnopqrstuvwxyz";
        $upper_case = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        $numbers = "1234567890";
        $symbols = "!@#$%^&*";

        $lower_case = str_shuffle($lower_case);
        $upper_case = str_shuffle($upper_case);
        $numbers = str_shuffle($numbers);
        $symbols = str_shuffle($symbols);

        $random_password = substr($lower_case, 0, $lower);
        $random_password .= substr($upper_case, 0, $upper);
        $random_password .= substr($numbers, 0, $digits);
        $random_password .= substr($symbols, 0, $special_characters);

        return  str_shuffle($random_password);
    }
    public function depositlist(Request $request)
    {
        // $apikey = 'T9fFGrpR2XoZ6wF';
        $affiliatekeys = AffiliateKey::where('api_key',$request->key)->first();
        $parts = parse_url($_SERVER['REQUEST_URI']);
        $key = $email = $start = $source = $end = '';
        if (!empty($parts['query'])) {
            parse_str($parts['query'], $query);
            $key = $query['key'];
            if (!empty($query['email'])) {
                $email = $query['email'];
            }
            if (!empty($query['start_date'])) {
                $start = $query['start_date'];
            }
            if (!empty($query['end_date'])) {
                $end = $query['end_date'];
            }
            if (!empty($query['source'])) {
                $source = $query['source'];
            }
        }
        if (empty($source)) {
            //  return 'invalid parameters';
            $array = array('status' => false, 'error' => 'invalid parameters');
            return response()->json($array);
        }
        if ($key != $affiliatekeys->api_key) {
            $array = array('status' => false, 'error' => 'invalid API key');
            return response()->json($array);
        } else {

            $uids = User::select('id')->pluck('id')->toArray();

            if (!empty($email)) {
                $checkuser = User::select('id')->where('email', $email)->first();
                $checkld = Leads::select('id')->where('email', $email)->where('source', $source)->first();
                if (empty($checkuser) || empty($checkld)) {
                    $array = array('status' => false, 'error' => 'no result found');
                    return response()->json($array);
                }
                $leads = Deposit::select('userid', 'amount', 'created_at as date')->where('userid', $checkuser->id)->where('displaystatus', '1')->get();

                if (empty($leads)) {
                    $array = array('status' => false, 'error' => 'no data found');
                    return response()->json($array);
                }
                if (!empty($start) && !empty($end)) {
                    $sdate = date('Y-m-d 00:00:00', strtotime($start));
                    $edate = date('Y-m-d 23:59:59', strtotime($end));
                    $leads = Deposit::select('userid', 'amount', 'created_at as date')->where('userid', $checkuser->id)->whereBetween('created_at', [$sdate, $edate])->where('displaystatus', '1')->get();
                }
            } else {
                $leads = Deposit::select('userid', 'amount', 'created_at as date')->whereIn('userid', $uids)->where('displaystatus', '1')->groupBy('userid')->orderBy('created_at', 'desc')->get();
                if (empty($leads)) {
                    $array = array('status' => false, 'error' => 'no data found');
                    return response()->json($array);
                }

                if (!empty($start) && !empty($end)) {
                    $sdate = date('Y-m-d 00:00:00', strtotime($start));
                    $edate = date('Y-m-d 23:59:59', strtotime($end));
                    $leads = Deposit::select('userid', 'amount', 'created_at as date')->whereIn('userid', $uids)->whereBetween('created_at', [$sdate, $edate])->where('displaystatus', '1')->groupBy('userid')->orderBy('created_at', 'desc')->get();
                }
            }
            $arraydata = array();
            foreach ($leads as $i => $lead) {
                $getus = User::select('id', 'email')->where('id', $lead->userid)->first();
                $getld = Leads::select('id')->where('source', $source)->where('email', $getus->email)->first();
                if (!empty($getld)) {
                    $arraydata[$i]['amount'] = $lead->amount;
                    $arraydata[$i]['date'] = $lead->date;
                    $arraydata[$i]['email'] = $getus->email;
                    $arraydata[$i]['lead_no'] = $getld->id;
                }
            }

            return response()->json(array('status' => true, 'response' => $arraydata));
        }
    }
}
