<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Mail\WelcomeMail;
use App\Models\Deposit;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use Exception;
use Illuminate\Auth\Events\Registered;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Laravel\Socialite\Facades\Socialite;

class RegisteredUserController extends Controller
{
    public function __construct()
    {
        $this->middleware('guest');
    }

    public function create()
    {
        $countries = DB::table('countries')->get();
        return view('auth.register', compact('countries'));
    }

    /**
     * Handle an incoming registration request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'mobile' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|confirmed|min:8',
            'country' => 'required|string',
            'promo' => 'nullable|string'
        ]);

        $ipAddress = $request->ip();

        $adduser = [];
        $adduser['name'] = $request->name;
        $adduser['email'] = $request->email;
        $adduser['mobile'] = $request->mobile;
        $adduser['country'] = $request->country;
        $adduser['password'] = Hash::make($request->password);
        $adduser['mypass'] = base64_encode($request->password);
        $adduser['ip_address'] = $ipAddress;
        if (!empty($request->promo)) {
            $checkaf = User::where('promo', $request->promo)->where('affiliate', '1')->first();
            if (!empty($checkaf)) {
                $adduser['afid'] = $checkaf->id;
            } else {
                $adduser['afid'] = NULL;
            }
        }
        // echo '<pre>';print_r($adduser);exit;
        $newuser = User::create($adduser);
        $newuser->roles()->sync(2);

        try {
            Mail::to($newuser->email)->send(new WelcomeMail($newuser, $adduser['mypass']));
        } catch (Exception $e) {
            Log::error('Mail sending failed: ' . $e->getMessage());
        }

        Auth::login($newuser);

        event(new Registered($newuser));

        return redirect(RouteServiceProvider::HOME);
    }

    /**
     * Redirect to Google for registration.
     */
    public function redirectToGoogleForRegistration()
    {
        return Socialite::driver('google')->stateless()->scopes(['openid', 'profile', 'email'])->redirect();
    }

    /**
     * Handle Google callback for registration.
     */
    public function handleGoogleRegistrationCallback(Request $request)
    {
        try {
            $socialUser = Socialite::driver('google')->stateless()->user();

            $user = User::where('email', $socialUser->getEmail())->first();

            if ($user) {
                return redirect()->route('register')->with('error', 'Email already registered. Please login.');
            }
            
            $ipAddress = $request->ip();

            $adduser = [];
            $adduser['name'] = $socialUser->getName() ?? 'Unknown User';
            $adduser['email'] = $socialUser->getEmail();
            $adduser['password'] = Hash::make(Str::random(10));
            $adduser['mypass'] = base64_encode(Str::random(10));
            $adduser['provider'] = 'google';
            $adduser['provider_id'] = $socialUser->getId();
            $adduser['ip_address'] = $ipAddress;

            // $user = User::create([
            //     'name' => $socialUser->getName() ?? 'Unknown User',
            //     'email' => $socialUser->getEmail(),
            //     'password' => Hash::make(Str::random(10)),
            //     'mypass' => base64_encode(Str::random(10)),
            //     'provider' => 'google',
            //     'provider_id' => $socialUser->getId(),
            // ]);
            // echo '<pre>';print_r($adduser);exit;
            
            $newuser = User::create($adduser);
            $newuser->roles()->sync(2);
            
            try {
                Mail::to($newuser->email)->send(new WelcomeMail($newuser, $adduser['mypass']));
            } catch (Exception $e) {
                Log::error('Mail sending failed: ' . $e->getMessage());
            }

            Auth::login($newuser);

            event(new Registered($newuser));

            return redirect()->route('admin.users.myprofile');
        } catch (Exception $e) {
            Log::error('Google registration failed: ' . $e->getMessage());
            return redirect()->route('register')->with('error', 'Failed to register using Google.');
        }
    }

    public function bitpayment(Request $request)
    {

        if ($request->status == 'paid') {
            $this->makeconnection();
            $getdeposit = Deposit::where('id', $request->order_id)->first();
            $percntage = $request->amount * 0.06;
            $finalamount = $request->amount - $percntage;

            $comnt = 'deposit-bitlocus';

            $url = $this->apicall . 'MAKE_DEPOIST_BALANCE?MT4Account=' . $getdeposit->mt4account . '&Amount=' . $finalamount . '&Comment=' . $comnt . '&ManagerIndex=' . $this->manager;
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $result = curl_exec($ch);

            $getdata = json_decode($result);
            curl_close($ch);

            Deposit::where('id', $request->order_id)->update(array(
                'status'     => '1',
                'displaystatus'     => '1',
            ));
        }
    }
    public function checkcbi()
    {
        $post = array(
            'trader' =>
            (object) array(
                'label' => 'finanza',
                'amount' => '10',
                'depoid' => 45,
                'custom2' => 'payment',
                'callback_url' => 'https://crm.finanza-invest.com/dopayment',
            ),
            'transaction' =>
            array(
                'id' => 'GP103069',
                'currency' => 'EUR',
                'currency_amount' => 10.0,
                'crypto' => 'BTC',
                'crypto_amount' => '0.00107424',
                'completed_at' => '2020-07-27 08:13:36',
            ),
            'status' => 'Declined',
            'user' =>
            array(
                'first_name' => 'Bill',
                'last_name' => 'Zolti',
                'email' => 'support@allfinancialmarket.com',
            ),
            'error_message' => 'Issuer country in blacklist',
            'card_last_four' => '1111',
            'buy_percentage_fee' => '6',
        );
        dd($post);
    }
    public function dopayment(Request $request)
    {
        //$this->makeconnection();
        if ($request['status'] == 'Completed' || $request['status'] == 'completed' || $request['status'] == 'success' || $request['status'] == 'Success') {
            $checkdepo = Deposit::where('id', $request['trader']->depoid)->first();
            $comnt = 'deposit-allglobal';

            //   $url = $this->apicall.'MAKE_DEPOIST_BALANCE?MT4Account='.$checkdepo->mt4account.'&Amount='.$request->amount.'&Comment='.$comnt.'&ManagerIndex='.$this->manager;
            $postfields = array(
                'method' => 'Deposit',
                'key' => '0001',
                'array' =>
                array(
                    0 =>
                    array(
                        'index' => 0,
                        'accountID' => $checkdepo->mt4account,
                        'comment' => $comnt,
                        'amount' => $request['trader']->amount,
                    ),
                ),
            );
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => "http://jenya.securedns.us:3001/capitalmanageinv",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => json_encode($postfields),
                CURLOPT_HTTPHEADER => array(
                    "Content-Type: text/plain"
                ),
            ));
            $response = curl_exec($curl);
            curl_close($curl);
            $getresult = json_decode($response);

            if ($getresult->applicationStatus == 'OK') {
                Deposit::where('id', $request['trader']->depoid)->update(array(
                    'displaystatus'     => '1',
                ));
            }
        }
    }
}
