<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class AccountDetailsMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $password;
    public $loginId;

    /**
     * Create a new message instance.
     *
     * @param $user
     * @param $password
     * @param $loginId
     * @return void
     */
    public function __construct($user, $password, $loginId)
    {
        $this->user = $user;
        $this->password = $password;
        $this->loginId = $loginId;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('emails.accountDetailMail')
            ->subject('Your Trading Account Details');
    }
}
