<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Edit Leads</h4>
                        </div>
                        <div class="card-action">
                            <a href="{{ route("admin.leads") }}" class="btn btn-sm btn-primary" role="button">Back</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route("admin.leadsupdate") }}" method="POST" role="form text-left" class="needs-validation" enctype="multipart/form-data">
                            @csrf
                            <div class="new-user-info">
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="email">E-Mail: <span class="text-danger">*</span></label>
                                        <input class="form-control" type="email" value="{{ $leaddata->email }}" placeholder="Email" id="email" name="email" required>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="leadowner">Lead Owner: <span class="text-danger">*</span></label>
                                        <select class="form-control" name="leadowner" id="leadowner" required>
                                            @if (count($accounts) > 0)
                                                @foreach ($accounts as $mtaccount)
                                                <option value="{{ $mtaccount->id }}"
                                                    @if ($leaddata->leadowner == $mtaccount->id) selected @endif>{{ $mtaccount->name }}
                                                </option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="status">Status:</label>
                                        <select class="form-control" name="status" id="status">
                                            <option value="FTD" @if ($leaddata->status == 'FTD') selected @endif>FTD</option>
                                            <option value="Callback" @if ($leaddata->status == 'Callback') selected @endif>Callback</option>
                                            <option value="Confirmed" @if ($leaddata->status == 'Confirmed') selected @endif>Confirmed</option>
                                            <option value="Hot" @if ($leaddata->status == 'Hot') selected @endif>Hot</option>
                                            <option value="Cold" @if ($leaddata->status == 'Cold') selected @endif>Cold</option>
                                            <option value="Not answered" @if ($leaddata->status == 'Not answered') selected @endif>Not answered</option>
                                            <option value="Not interested" @if ($leaddata->status == 'Not interested') selected @endif>Not interested</option>
                                            <option value="Not relevant" @if ($leaddata->status == 'Not relevant') selected @endif>Not relevant</option>
                                            <option value="New" @if ($leaddata->status == 'New') selected @endif>New</option>
                                        </select>
                                        <input type="hidden" name="id" value="{{ $id }}">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="note">Comment:</label>
                                        <input class="form-control" type="text" placeholder="Comment" id="note" name="note" value="{{ $leaddata->note }}">
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-sm btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
