<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Send Withdraw Request</h4>
                        </div>
                        <div class="card-action">
                            <a href="{{ route("admin.withdraw.index") }}" class="btn btn-sm btn-primary" role="button">Back</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route("admin.withdraw.store") }}" method="POST" role="form text-left" class="needs-validation" enctype="multipart/form-data">
                            @csrf
                            <div class="new-user-info">
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="mt4account">Select MT5account <span class="text-danger">*</span></label>
                                        <select class="form-control" name="mt4account" id="mt4account">
                                            @if (count($accounts) > 0)
                                                @foreach ($accounts as $mtaccount)
                                                    <option value="{{ $mtaccount->loginid }}">{{ $mtaccount->loginid }}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="benename">Beneficiary Name <span class="text-danger">*</span></label>
                                        <input class="form-control" type="text" placeholder="Beneficiary Name" id="benename" name="benename" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="paymentmethod">Payment Method <span class="text-danger">*</span></label>
                                        <input class="form-control" value="Wire Transfer" type="text" placeholder="Payment Method" id="paymentmethod" name="paymentmethod" readonly>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="country">Country</label>
                                        <select class="form-control" name="country" id="country" required>
                                            @foreach($countries as $country)
                                                <option value="{{ $country->name }}">{{ $country->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="bankname">Bank Name <span class="text-danger">*</span></label>
                                        <input class="form-control" value="" type="text" placeholder="Bank Name" id="bankname" name="bankname" required>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="bankaddress">Bank Address <span class="text-danger">*</span></label>
                                        <input class="form-control" value="" type="text" placeholder="Bank Address" id="bankaddress" name="bankaddress" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="accountno">Bank Account Number <span class="text-danger">*</span></label>
                                        <input class="form-control" value="" type="text" placeholder="Bank Account Number" id="accountno" name="accountno" required>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="swiftcode">Swift Code <span class="text-danger">*</span></label>
                                        <input class="form-control" value="" type="text" placeholder="Swift Code" id="swiftcode" name="swiftcode" required>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="amount">Amount <span class="text-danger">*</span></label>
                                        <input class="form-control" value="" type="number" placeholder="Amount" id="amount" name="amount" min="0" required>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="description">Description</label>
                                        <textarea class="form-control" name="description" id="description" cols="30" rows="10"></textarea>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-sm btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
