<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Leads;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class LimportController extends Controller
{
    public function messages()
    {
        return [
            'newpassword.required' => 'password required',
        ];
    }

    public function leadimport()
    {
        //$f = Leads::get();
        //dd($f);
        $checkadmin = Gate::allows('permission_create');
        if ($checkadmin == true) {
            return view('admin.affiliate.leadimport');
        } else {
            abort(403);
        }


        return view('admin.affiliate.leadimport');
    }

    public function storelimport(Request $request)
    {

        if ($request->hasFile('import_file')) {

            $file = $request->file('import_file');

            $filename = $file->getClientOriginalName();
            $extension = $file->getClientOriginalExtension();
            $tempPath = $file->getRealPath();
            $fileSize = $file->getSize();
            $mimeType = $file->getMimeType();

            $valid_extension = array("csv");

            $maxFileSize = 2097152;

            if (in_array(strtolower($extension), $valid_extension)) {

                if ($fileSize <= $maxFileSize) {

                    $location = 'uploads';

                    $file->move($location, $filename);

                    $filepath = public_path($location . "/" . $filename);

                    $file = fopen($filepath, "r");

                    $importData_arr = array();
                    $i = 0;

                    while (($filedata = fgetcsv($file, 1000, ",")) !== FALSE) {
                        $num = count($filedata);

                        if ($i == 0) {
                            $i++;
                            continue;
                        }
                        for ($c = 0; $c < $num; $c++) {
                            $importData_arr[$i][] = $filedata[$c];
                        }
                        $i++;
                    }
                    fclose($file);

                    // Insert to MySQL database
                    foreach ($importData_arr as $importData) {

                        $insertData = array(
                            "firstname" => $importData[0],
                            "lastname" => $importData[1],
                            "email" => $importData[2],
                            //  "password"=>$importData[3],
                            "country" => $importData[4],
                            "mobile" => $importData[5],
                            "source" => $importData[6],
                            "status" => $importData[7],
                            // "comment"=>$importData[8],
                        );
                        // dd($insertData);
                        Leads::create($insertData);
                    }
                    return redirect()->back()->with('message', 'Import Successful.');
                } else {
                    return redirect()->back()->with('message', 'File too large. File must be less than 2MB.');
                }
            } else {
                return redirect()->back()->with('message', 'Invalid File Extension.');
            }
        }

        return redirect()->back();
    }
}
