<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;

class SettingController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $settings = Setting::all();

        return view('admin.settings.index', compact('settings'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.settings.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $settings = new Setting();
        $settings->description = $request->input('description');
        $settings->status = $request->input('status');
        // echo '<pre>';print_r($settings);exit;

        $settings->save();

        return redirect()->route('admin.settings.index')->with('success','Setting added successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $settings = Setting::findOrFail($id);

        return view('admin.settings.edit', compact('settings'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $settings = Setting::findOrFail($id);
        $settings->description = $request->input('description');
        $settings->status = $request->input('status');
        // echo '<pre>';print_r($settings);exit;

        $settings->save();

        return redirect()->route('admin.settings.index')->with('success','Setting updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $settings = Setting::findOrFail($id);
        $settings->delete();

        return redirect()->route('admin.settings.index')->with('success','Setting deleted successfully');
    }
}
