<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <form id="account-form" action="{{ url('admin/client/openposition') }}" method="GET">
                        @csrf
                        <div class="row" style="margin-left: 15px; margin-top: 10px;">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="form-label" for="account">Select Account</label>
                                    <select class="form-control" name="account" id="account">
                                        @if(count($accounts) > 0)
                                            @foreach($accounts as $account)
                                                <option value="{{ $account->loginid }}" {{ $mtaccount == $account->loginid ? 'selected' : '' }}>
                                                    {{ $account->loginid }}
                                                </option>
                                            @endforeach
                                        @endif
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <input class="btn btn-sm btn-success" type="submit" value="Submit" style="margin-top:37px;">
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Open Positions</h4>
                        </div>
                    </div>
                    <div class="card-body px-0">
                        <div class="table-responsive">
                            <table class="table table-bordered" role="grid" id="positions-table" data-toggle="data-table">
                                <thead>
                                    <tr class="light">
                                        <th style="text-align: center">Login ID</th>
                                        <th style="text-align: center">Lot</th>
                                        <th style="text-align: center">Open Price</th>
                                        <th style="text-align: center">Profit</th>
                                        <th style="text-align: center">Swap</th>
                                        <th style="text-align: center">Symbol</th>
                                    </tr>
                                </thead>
                                <tbody id="positions-body">
                                    @foreach ($positions as $position)
                                        <tr data-entry-id="{{ $position->Login }}">
                                            <td class="text-center">{{ $position->Login ?? '' }}</td>
                                            <td class="text-center">{{ $position->Volume / 10000 ?? '' }}</td>
                                            <td class="text-center">{{ $position->PriceOpen ?? '' }}</td>
                                            <td class="text-center">{{ $position->Profit ?? '' }}</td>
                                            <td class="text-center">{{ $position->Storage ?? '' }}</td>
                                            <td class="text-center">{{ $position->Symbol ?? '' }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(function() {
            let deleteButtonTrans = '{{ trans('global.datatables.delete') }}'
            let deleteButton = {
                text: deleteButtonTrans,
                url: "{{ route('admin.products.massDestroy') }}",
                className: 'btn-danger',
                action: function(e, dt, node, config) {
                    var ids = $.map(dt.rows({
                        selected: true
                    }).nodes(), function(entry) {
                        return $(entry).data('entry-id')
                    });

                    if (ids.length === 0) {
                        alert('{{ trans('global.datatables.zero_selected') }}')

                        return
                    }

                    if (confirm('{{ trans('global.areYouSure') }}')) {
                        $.ajax({
                                headers: {
                                    'x-csrf-token': _token
                                },
                                method: 'POST',
                                url: config.url,
                                data: {
                                    ids: ids,
                                    _method: 'DELETE'
                                }
                            })
                            .done(function() {
                                location.reload()
                            })
                    }
                }
            }

            let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
            @can('product_delete')
                // dtButtons.push(deleteButton)
            @endcan

            $('.datatable:not(.ajaxTable)').DataTable({
                buttons: dtButtons
            })
        })

        $(document).ready(function () {
            function fetchPositions() {
                const account = $('#account').val();

                $.ajax({
                    url: "{{ url('admin/client/openposition') }}",
                    method: 'GET',
                    data: {
                        account: account,
                        _token: '{{ csrf_token() }}'
                    },
                    success: function (response) {
                        updateTable(response.positions);
                    },
                    error: function (error) {
                        console.error('Error fetching positions:', error);
                    }
                });
            }

            function updateTable(positions) {
                let tableBody = '';

                if (positions.length > 0) {
                    positions.forEach((position) => {
                        tableBody += `
                            <tr data-entry-id="${position.Login}">
                                <td class="text-center">${position.Login ?? ''}</td>
                                <td class="text-center">${position.Volume / 10000 ?? ''}</td>
                                <td class="text-center">${position.PriceOpen ?? ''}</td>
                                <td class="text-center">${position.Profit ?? ''}</td>
                                <td class="text-center">${position.Storage ?? ''}</td>
                                <td class="text-center">${position.Symbol ?? ''}</td>
                            </tr>
                        `;
                    });
                } else {
                    tableBody = `<tr><td colspan="6" class="text-center">No data available in table</td></tr>`;
                }

                $('#positions-body').html(tableBody);
            }

            setInterval(fetchPositions, 10000);

            fetchPositions();

            $('#account').change(fetchPositions);
        });
    </script>
</x-app-layout>
