<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Leverage Change</h4>
                        </div>
                        <div class="card-action">
                            <a href="{{ route("admin.users.index") }}" class="btn btn-sm btn-primary" role="button">Back</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('admin.users.leverage.store', $accounts->loginid) }}" method="POST" role="form text-left" class="needs-validation" enctype="multipart/form-data">
                            @csrf
                            <div class="new-user-info">
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="leverage">Select Leverage</label>
                                        <select class="form-control" name="leverage" id="leverage">
                                            <option value="100" {{ $accounts->leverage == 100 ? 'selected' : '' }}>1:100</option>
                                            <option value="200" {{ $accounts->leverage == 200 ? 'selected' : '' }}>1:200</option>
                                            <option value="300" {{ $accounts->leverage == 300 ? 'selected' : '' }}>1:300</option>
                                            <option value="400" {{ $accounts->leverage == 400 ? 'selected' : '' }}>1:400</option>
                                        </select>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-sm btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
