<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Auth;

class Appointment extends Model
{
    use SoftDeletes;

		protected $table = 'appointments';

		protected $primaryKey = 'id';

	protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $fillable = [
        'lead_id',
        'appointment_note',
        'appointment_date',
        'appointment_time',
    ];

    public function lead()
    {
        return $this->belongsTo(Leads::class);
    }

    protected static function boot()
    {
        parent::boot();

        static::created(function ($model) {
            $user = Auth::user();
            $userRoles = $user ? $user->roles->pluck('title')->implode(', ') : 'guest';

            Log::create([
                'user_id'      => $user ? $user->id : null,
                'role'         => $userRoles,
                'action'       => 'create',
                'description'  => 'Created ' . get_class($model),
                'ip_address'   => request()->ip(),
            ]);
        });

        static::updated(function ($model) {
            $user = Auth::user();
            $userRoles = $user ? $user->roles->pluck('title')->implode(', ') : 'guest';

            Log::create([
                'user_id'      => $user ? $user->id : null,
                'role'         => $userRoles,
                'action'       => 'update',
                'description'  => 'Updated ' . get_class($model),
                'ip_address'   => request()->ip(),
            ]);
        });

        static::deleted(function ($model) {
            $user = Auth::user();
            $userRoles = $user ? $user->roles->pluck('title')->implode(', ') : 'guest';

            Log::create([
                'user_id'      => $user ? $user->id : null,
                'role'         => $userRoles,
                'action'       => 'delete',
                'description'  => 'Deleted ' . get_class($model),
                'ip_address'   => request()->ip(),
            ]);
        });
    }
}
