/*
Template: Hope-Ui - Responsive Bootstrap 5 Admin Dashboard Template
Author: iqonic.design
Design and Developed by: iqonic.design
NOTE: This file contains the all calender events.
*/
"use strict";

if (document.querySelectorAll("#calendar1").length) {
    document.addEventListener("DOMContentLoaded", function () {
        let calendarEl = document.getElementById("calendar1");
        let calendar1 = new FullCalendar.Calendar(calendarEl, {
            selectable: true,
            plugins: ["timeGrid", "dayGrid", "list", "interaction"],
            timeZone: "UTC",
            defaultView: "dayGridMonth",
            contentHeight: "auto",
            eventLimit: true,
            dayMaxEvents: 4,
            header: {
                left: "prev,next today",
                center: "title",
                right: "dayGridMonth,timeGridWeek,timeGridDay,listWeek",
            },
            dateClick: function (info) {
                $("#schedule-start-date").val(info.dateStr);
                $("#schedule-end-date").val(info.dateStr);
                $("#date-event").modal("show");
            },
            events: [
                {
                    title: "Click for Google",
                    url: "http://google.com/",
                    start:
                        moment(new Date(), "YYYY-MM-DD")
                            .add(-20, "days")
                            .format("YYYY-MM-DD") + "T05:30:00.000Z",
                    backgroundColor: "rgba(58,87,232,0.2)",
                    textColor: "rgba(58,87,232,1)",
                    borderColor: "rgba(58,87,232,1)",
                },
                {
                    title: "All Day Event",
                    start:
                        moment(new Date(), "YYYY-MM-DD")
                            .add(-18, "days")
                            .format("YYYY-MM-DD") + "T05:30:00.000Z",
                    backgroundColor: "rgba(108,117,125,0.2)",
                    textColor: "rgba(108,117,125,1)",
                    borderColor: "rgba(108,117,125,1)",
                },
                {
                    title: "Long Event",
                    start:
                        moment(new Date(), "YYYY-MM-DD")
                            .add(-16, "days")
                            .format("YYYY-MM-DD") + "T05:30:00.000Z",
                    end:
                        moment(new Date(), "YYYY-MM-DD")
                            .add(-13, "days")
                            .format("YYYY-MM-DD") + "T05:30:00.000Z",
                    backgroundColor: "rgba(8,130,12,0.2)",
                    textColor: "rgba(8,130,12,1)",
                    borderColor: "rgba(8,130,12,1)",
                },
                {
                    groupId: "999",
                    title: "Repeating Event",
                    start:
                        moment(new Date(), "YYYY-MM-DD")
                            .add(-14, "days")
                            .format("YYYY-MM-DD") + "T05:30:00.000Z",
                    color: "#047685",
                    backgroundColor: "rgba(4,118,133,0.2)",
                    textColor: "rgba(4,118,133,1)",
                    borderColor: "rgba(4,118,133,1)",
                },
                {
                    groupId: "999",
                    title: "Repeating Event",
                    start:
                        moment(new Date(), "YYYY-MM-DD")
                            .add(-12, "days")
                            .format("YYYY-MM-DD") + "T05:30:00.000Z",
                    backgroundColor: "rgba(235,153,27,0.2)",
                    textColor: "rgba(235,153,27,1)",
                    borderColor: "rgba(235,153,27,1)",
                },
                {
                    groupId: "999",
                    title: "Repeating Event",
                    start:
                        moment(new Date(), "YYYY-MM-DD")
                            .add(-10, "days")
                            .format("YYYY-MM-DD") + "T05:30:00.000Z",
                    backgroundColor: "rgba(206,32,20,0.2)",
                    textColor: "rgba(206,32,20,1)",
                    borderColor: "rgba(206,32,20,1)",
                },
                {
                    title: "Birthday Party",
                    start:
                        moment(new Date(), "YYYY-MM-DD")
                            .add(-8, "days")
                            .format("YYYY-MM-DD") + "T05:30:00.000Z",
                    backgroundColor: "rgba(58,87,232,0.2)",
                    textColor: "rgba(58,87,232,1)",
                    borderColor: "rgba(58,87,232,1)",
                },
                {
                    title: "Meeting",
                    start:
                        moment(new Date(), "YYYY-MM-DD")
                            .add(-6, "days")
                            .format("YYYY-MM-DD") + "T05:30:00.000Z",
                    backgroundColor: "rgba(58,87,232,0.2)",
                    textColor: "rgba(58,87,232,1)",
                    borderColor: "rgba(58,87,232,1)",
                },
                {
                    title: "Birthday Party",
                    start:
                        moment(new Date(), "YYYY-MM-DD")
                            .add(-5, "days")
                            .format("YYYY-MM-DD") + "T05:30:00.000Z",
                    backgroundColor: "rgba(235,153,27,0.2)",
                    textColor: "rgba(235,153,27,1)",
                    borderColor: "rgba(235,153,27,1)",
                },
                {
                    title: "Birthday Party",
                    start:
                        moment(new Date(), "YYYY-MM-DD")
                            .add(-2, "days")
                            .format("YYYY-MM-DD") + "T05:30:00.000Z",
                    backgroundColor: "rgba(235,153,27,0.2)",
                    textColor: "rgba(235,153,27,1)",
                    borderColor: "rgba(235,153,27,1)",
                },

                {
                    title: "Meeting",
                    start:
                        moment(new Date(), "YYYY-MM-DD")
                            .add(0, "days")
                            .format("YYYY-MM-DD") + "T05:30:00.000Z",
                    backgroundColor: "rgba(58,87,232,0.2)",
                    textColor: "rgba(58,87,232,1)",
                    borderColor: "rgba(58,87,232,1)",
                },
                {
                    title: "Click for Google",
                    url: "http://google.com/",
                    start:
                        moment(new Date(), "YYYY-MM-DD")
                            .add(0, "days")
                            .format("YYYY-MM-DD") + "T06:30:00.000Z",
                    backgroundColor: "rgba(58,87,232,0.2)",
                    textColor: "rgba(58,87,232,1)",
                    borderColor: "rgba(58,87,232,1)",
                },
                {
                    groupId: "999",
                    title: "Repeating Event",
                    start:
                        moment(new Date(), "YYYY-MM-DD")
                            .add(0, "days")
                            .format("YYYY-MM-DD") + "T07:30:00.000Z",
                    backgroundColor: "rgba(58,87,232,0.2)",
                    textColor: "rgba(58,87,232,1)",
                    borderColor: "rgba(58,87,232,1)",
                },
                {
                    title: "Birthday Party",
                    start:
                        moment(new Date(), "YYYY-MM-DD")
                            .add(0, "days")
                            .format("YYYY-MM-DD") + "T08:30:00.000Z",
                    backgroundColor: "rgba(235,153,27,0.2)",
                    textColor: "rgba(235,153,27,1)",
                    borderColor: "rgba(235,153,27,1)",
                },
                {
                    title: "Doctor Meeting",
                    start:
                        moment(new Date(), "YYYY-MM-DD")
                            .add(0, "days")
                            .format("YYYY-MM-DD") + "T05:30:00.000Z",
                    backgroundColor: "rgba(235,153,27,0.2)",
                    textColor: "rgba(235,153,27,1)",
                    borderColor: "rgba(235,153,27,1)",
                },
                {
                    title: "All Day Event",
                    start:
                        moment(new Date(), "YYYY-MM-DD")
                            .add(1, "days")
                            .format("YYYY-MM-DD") + "T05:30:00.000Z",
                    backgroundColor: "rgba(58,87,232,0.2)",
                    textColor: "rgba(58,87,232,1)",
                    borderColor: "rgba(58,87,232,1)",
                },
                {
                    groupId: "999",
                    title: "Repeating Event",
                    start:
                        moment(new Date(), "YYYY-MM-DD")
                            .add(8, "days")
                            .format("YYYY-MM-DD") + "T05:30:00.000Z",
                    backgroundColor: "rgba(58,87,232,0.2)",
                    textColor: "rgba(58,87,232,1)",
                    borderColor: "rgba(58,87,232,1)",
                },
                {
                    groupId: "999",
                    title: "Repeating Event",
                    start:
                        moment(new Date(), "YYYY-MM-DD")
                            .add(10, "days")
                            .format("YYYY-MM-DD") + "T05:30:00.000Z",
                    backgroundColor: "rgba(58,87,232,0.2)",
                    textColor: "rgba(58,87,232,1)",
                    borderColor: "rgba(58,87,232,1)",
                },
            ],
        });
        calendar1.render();
    });
}

if (document.querySelectorAll("#appointmentCalendar").length) {
    document.addEventListener("DOMContentLoaded", function () {
        let calendarEl = document.getElementById("appointmentCalendar");
        let id = '{{ $id }}';

        let appointmentCalendar = new FullCalendar.Calendar(calendarEl, {
            selectable: true,
            plugins: ["timeGrid", "dayGrid", "list", "interaction"],
            timeZone: "UTC",
            defaultView: "dayGridMonth",
            contentHeight: "auto",
            eventLimit: true,
            dayMaxEvents: 4,
            header: {
                left: "prev,next today",
                center: "title",
                right: "dayGridMonth,timeGridWeek,timeGridDay,listWeek",
            },
            dateClick: function (info) {
                $("#schedule-start-date").val(info.dateStr);
                $("#schedule-end-date").val(info.dateStr);
                $("#date-event").modal("show");
            },
            events: {
                url: `https://crm.fxdemo.site//public/admin/appointments/${id}`,
                method: 'GET',
                failure: function () {
                    alert("Error fetching appointments data.");
                },
            },
            eventTimeFormat: {
                hour: 'numeric',
                minute: '2-digit',
                meridiem: 'short',
            },
            eventColor: '#3788d8',
        });

        appointmentCalendar.render();
    });
}

