<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">MT5 Demo Account List</h4>
                        </div>
                        <div class="card-action">
                            <div style="margin-bottom: 10px;" class="row">
                                <div class="col-lg-12">
                                    @if ($checkadmin == false && Auth::user()->affiliate != '1')
                                        <a class="btn btn-sm btn-success" href="{{ route('admin.opendemoaccount') }}">
                                            Open Mt5 Demo Account
                                        </a>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-body px-0">
                        <div class="table-responsive">
                            <table class="table table-bordered" role="grid" data-toggle="data-table">
                                <thead>
                                    <tr class="light">
                                        <th width="10"></th>
                                        <th style="text-align: center">Login ID</th>
                                        <th style="text-align: center">Client Name</th>
                                        <th style="text-align: center">Email</th>
                                        <th style="text-align: center">Password</th>
                                        <th style="text-align: center">Group Name</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($accounts as $key => $product)
                                        <tr data-entry-id="{{ $product->loginid }}">
                                            <td><input type="checkbox" name="bulk-select" class="user-checkbox"></td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->loginid ?? '' }}
                                                </p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->name ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->email ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->mainpass ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->groupname ?? '' }}</p>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        $(function() {
            let deleteButtonTrans = '{{ trans('global.datatables.delete') }}'
            let deleteButton = {
                text: deleteButtonTrans,
                url: "{{ route('admin.products.massDestroy') }}",
                className: 'btn-danger',
                action: function(e, dt, node, config) {
                    var ids = $.map(dt.rows({
                        selected: true
                    }).nodes(), function(entry) {
                        return $(entry).data('entry-id')
                    });

                    if (ids.length === 0) {
                        alert('{{ trans('global.datatables.zero_selected') }}')

                        return
                    }

                    if (confirm('{{ trans('global.areYouSure') }}')) {
                        $.ajax({
                                headers: {
                                    'x-csrf-token': _token
                                },
                                method: 'POST',
                                url: config.url,
                                data: {
                                    ids: ids,
                                    _method: 'DELETE'
                                }
                            })
                            .done(function() {
                                location.reload()
                            })
                    }
                }
            }
            let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
            @can('product_delete')
                // dtButtons.push(deleteButton)
            @endcan

            $('.datatable:not(.ajaxTable)').DataTable({
                'iDisplayLength': 600,
                buttons: dtButtons
            })
        })
    </script>
</x-app-layout>
