<x-app-layout :assets="$assets ?? []">
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex flex-wrap align-items-center justify-content-between">
                        <div class="d-flex flex-wrap align-items-center">
                            <div class="d-flex flex-wrap align-items-center mb-3 mb-sm-0">
                                <h4 class="me-2 h4">{{ $user->name }}</h4>
                                <span class="text-capitalize"> -
                                    {{ str_replace('_', ' ', $user->roles->pluck('title')->implode(', ')) }}</span>
                            </div>
                        </div>
                        <div class="d-flex flex-wrap align-items-center mb-3 mb-sm-0">
                            <a href="{{ route("admin.users.usersaffiliate") }}" class="btn btn-sm btn-primary" role="button">Back</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-5">
            <div class="card">
                <div class="card-header">
                    <div class="header-title">
                        <h4 class="card-title">User</h4>
                    </div>
                </div>
                <div class="card-body">
                    <div class="text-center">
                        <div class="user-profile">
                            <img src="{{ asset('images/avatars/01.png') }}" alt="profile-img"
                                class="rounded-pill avatar-130 img-fluid">
                        </div>
                        <div class="mt-3">
                            <h3 class="d-inline-block">{{ $user->name }}</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-7">
            <div class="card">
                <div class="card-header">
                    <div class="header-title">
                        <h4 class="card-title">About User</h4>
                    </div>
                </div>
                <div class="card-body">
                    <div class="mt-2">
                        <h6 class="mb-1">Name:</h6>
                        <p>{{ $user->name }}</p>
                    </div>
                    <div class="mt-2">
                        <h6 class="mb-1">Email:</h6>
                        <p><a href="#" class="text-body"> {{ $user->email }}</a></p>
                    </div>
                    <div class="mt-2">
                        <h6 class="mb-1">Email Verified At:</h6>
                        <p>{{ $user->email_verified_at }}</p>
                    </div>
                    <div class="mt-2">
                        <h6 class="mb-1">Roles:</h6>
                        <p>{{ str_replace('_', ' ', $user->roles->pluck('title')->implode(', ')) }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
