import { __assign } from "tslib";
var ScrollbarPlugin = /** @class */ (function () {
    function ScrollbarPlugin(scrollbar, options) {
        var _newTarget = this.constructor;
        this.scrollbar = scrollbar;
        this.name = _newTarget.pluginName;
        this.options = __assign(__assign({}, _newTarget.defaultOptions), options);
    }
    ScrollbarPlugin.prototype.onInit = function () { };
    ScrollbarPlugin.prototype.onDestroy = function () { };
    ScrollbarPlugin.prototype.onUpdate = function () { };
    ScrollbarPlugin.prototype.onRender = function (_remainMomentum) { };
    ScrollbarPlugin.prototype.transformDelta = function (delta, _evt) {
        return __assign({}, delta);
    };
    ScrollbarPlugin.pluginName = '';
    ScrollbarPlugin.defaultOptions = {};
    return ScrollbarPlugin;
}());
export { ScrollbarPlugin };
export var globalPlugins = {
    order: new Set(),
    constructors: {},
};
export function addPlugins() {
    var Plugins = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        Plugins[_i] = arguments[_i];
    }
    Plugins.forEach(function (P) {
        var pluginName = P.pluginName;
        if (!pluginName) {
            throw new TypeError("plugin name is required");
        }
        globalPlugins.order.add(pluginName);
        globalPlugins.constructors[pluginName] = P;
    });
}
export function initPlugins(scrollbar, options) {
    return Array.from(globalPlugins.order)
        .filter(function (pluginName) {
        return options[pluginName] !== false;
    })
        .map(function (pluginName) {
        var Plugin = globalPlugins.constructors[pluginName];
        var instance = new Plugin(scrollbar, options[pluginName]);
        // bind plugin options to `scrollbar.options`
        options[pluginName] = instance.options;
        return instance;
    });
}
//# sourceMappingURL=plugin.js.map