<x-app-layout :assets="$assets ?? []">
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <div class="header-title">
                        <h4 class="card-title">API Keys</h4>
                    </div>
                    <div class="card-action">
                        @can('user_create')
                            <div style="margin-bottom: 10px;" class="row">
                                <div class="col-lg-12">
                                    @if (Auth::user()->affiliate != '1')
                                        <a class="btn btn-sm btn-success" href="{{ url('apikeys/create') }}"> Add API Key </a>
                                    @endif
                                </div>
                            </div>
                        @endcan
                    </div>
                </div>
                <div class="card-body px-0">
                    <div class="table-responsive">
                        <table class="table table-bordered" role="grid" data-toggle="data-table">
                            <thead>
                                <tr class="light">
                                    <th width="10"></th>
                                    <th style="text-align: center">ID</th>
                                    <th style="text-align: center">Source</th>
                                    <th style="text-align: center">API Key</th>
                                    <th style="min-width: 100px; text-align:center;">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($affiliatekey as $key => $apikey)
                                    <tr data-entry-id="{{ $apikey->id }}">
                                        <td><input type="checkbox" name="bulk-select" class="user-checkbox"></td>
                                        <td class="text-center">
                                            <p class="text-xs font-weight-bold mb-0">{{ $apikey->id ?? '' }}</p>
                                        </td>
                                        <td class="text-center">
                                            <p class="text-xs font-weight-bold mb-0">{{ $apikey->source ?? '' }}</p>
                                        </td>
                                        <td class="text-center">
                                            <p class="text-xs font-weight-bold mb-0">{{ $apikey->api_key ?? '' }}</p>
                                        </td>
                                        <td class="text-center">
                                            <div class="flex align-items-center list-user-action">
                                                <form action="{{ url('apikeys/destroy/' . $apikey->id) }}"
                                                    method="POST" style="display:inline;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-icon btn-danger"
                                                        data-toggle="tooltip" data-placement="top" title="Delete"
                                                        onclick="return confirm('Are you sure you want to delete?');">
                                                        <span class="btn-inner">
                                                            <svg width="20" viewBox="0 0 24 24"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg"
                                                                stroke="currentColor">
                                                                <path
                                                                    d="M19.3248 9.46826C19.3248 9.46826 18.7818 16.2033 18.4668 19.0403C18.3168 20.3953 17.4798 21.1893 16.1088 21.2143C13.4998 21.2613 10.8878 21.2643 8.27979 21.2093C6.96079 21.1823 6.13779 20.3783 5.99079 19.0473C5.67379 16.1853 5.13379 9.46826 5.13379 9.46826"
                                                                    stroke="currentColor" stroke-width="1.5"
                                                                    stroke-linecap="round"
                                                                    stroke-linejoin="round"></path>
                                                                <path d="M20.708 6.23975H3.75"
                                                                    stroke="currentColor" stroke-width="1.5"
                                                                    stroke-linecap="round"
                                                                    stroke-linejoin="round"></path>
                                                                <path
                                                                    d="M17.4406 6.23973C16.6556 6.23973 15.9796 5.68473 15.8256 4.91573L15.5826 3.69973C15.4326 3.13873 14.9246 2.75073 14.3456 2.75073H10.1126C9.53358 2.75073 9.02558 3.13873 8.87558 3.69973L8.63258 4.91573C8.47858 5.68473 7.80258 6.23973 7.01758 6.23973"
                                                                    stroke="currentColor" stroke-width="1.5"
                                                                    stroke-linecap="round"
                                                                    stroke-linejoin="round"></path>
                                                            </svg>
                                                        </span>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(function () {
            let deleteButtonTrans = '{{ trans('global.datatables.delete') }}'
            let deleteButton = {
                text: deleteButtonTrans,
                url: "{{ url('apikeys/destroy') }}",
                className: 'btn-danger',
                action: function (e, dt, node, config) {
                var ids = $.map(dt.rows({ selected: true }).nodes(), function (entry) {
                    return $(entry).data('entry-id')
                });

                if (ids.length === 0) {
                    alert('{{ trans('global.datatables.zero_selected') }}')

                    return
                }

                if (confirm('{{ trans('global.areYouSure') }}')) {
                    $.ajax({
                    headers: {'x-csrf-token': _token},
                    method: 'POST',
                    url: config.url,
                    data: { ids: ids, _method: 'DELETE' }})
                    .done(function () { location.reload() })
                }
                }
            }
            let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)


            $('.datatable:not(.ajaxTable)').DataTable({ buttons: dtButtons })
        })
    </script>
</x-app-layout>
