<?php

namespace App\Http\Middleware;

use App\Models\Log;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class LogActivity
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next)
    {
        $response = $next($request);

        $user = Auth::user();
        $userRoles = $user ? $user->roles->pluck('title')->implode(', ') : 'guest';

        $action = $request->method();
        $modelName = $this->getModelName($request);

        $description = match ($action) {
            'POST'   => "$modelName Created",
            'PUT'    => "$modelName Updated",
            'DELETE' => "$modelName Deleted",
            default  => "Accessed $modelName",
        };

        Log::create([
            'user_id'      => $user ? $user->id : null,
            'role'         => $userRoles,
            'action'       => $action,
            'description'  => $description,
            'ip_address'   => $request->ip(),
        ]);

        return $response;
    }

    /**
     * Infer the model name based on the request.
     */
    private function getModelName(Request $request)
    {
        $route = $request->route();
        $controller = $route ? $route->getActionName() : null;

        if ($controller) {
            $controllerParts = explode('\\', $controller);
            $controllerName = end($controllerParts);

            return str_replace('Controller', '', $controllerName);
        }

        return 'Unknown Model'; 
    }
}
