<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <form action="{{ url('admin/client/closetrades') }}" method="GET" enctype="multipart/form-data">
                        @csrf
                        <div class="row" style="margin-left: 15px; margin-top: 10px;">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="form-label" for="account">Select Account</label>
                                    <select class="form-control" name="account" id="account">
                                        @if(count($accounts) > 0)
                                            @foreach($accounts as $account)
                                                <option value="{{$account->loginid}}" @if($mtaccount == $account->loginid) selected @endif>{{$account->loginid}}</option>
                                            @endforeach
                                        @endif
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2"><input class="btn btn-sm btn-success" type="submit" value="Submit" style="margin-top:37px;"></div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Close Trades</h4>
                        </div>
                    </div>
                    <div class="card-body px-0">
                        <div class="table-responsive">
                            <table class="table table-bordered" role="grid" data-toggle="data-table">
                                <thead>
                                    <tr class="light">
                                        <th style="text-align: center">Login ID</th>
                                        <th style="text-align: center">Close Price</th>
                                        <th style="text-align: center">Lot</th>
                                        <th style="text-align: center">Open Price</th>
                                        <th style="text-align: center">Symbol</th>
                                        <th style="text-align: center">Close Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if(count($positions)>0)
                                        @foreach ($positions as $key => $product)
                                            @if($product->PriceCurrent != 0)
                                                <tr data-entry-id="{{ $product->Login}}">
                                                    <td class="text-center">
                                                        <p class="text-xs font-weight-bold mb-0">{{ $product->Login ?? '' }}</p>
                                                    </td>
                                                    <td class="text-center">
                                                        <p class="text-xs font-weight-bold mb-0">{{ $product->PriceCurrent ?? '' }}</p>
                                                    </td>
                                                    <td class="text-center">
                                                        <p class="text-xs font-weight-bold mb-0">{{ $product->VolumeInitial/10000 ?? '' }}</p>
                                                    </td>
                                                    <td class="text-center">
                                                        <p class="text-xs font-weight-bold mb-0">{{ $product->PriceOrder ?? '' }}</p>
                                                    </td>
                                                    <td class="text-center">
                                                        <p class="text-xs font-weight-bold mb-0">{{ $product->Symbol ?? '' }}</p>
                                                    </td>
                                                    <td class="text-center">
                                                        <p class="text-xs font-weight-bold mb-0">{{ $product->TimeDone ?? '' }}</p>
                                                    </td>
                                                </tr>
                                            @endif
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(function() {
            let deleteButtonTrans = '{{ trans('global.datatables.delete') }}'
            let deleteButton = {
                text: deleteButtonTrans,
                url: "{{ route('admin.products.massDestroy') }}",
                className: 'btn-danger',
                action: function(e, dt, node, config) {
                    var ids = $.map(dt.rows({
                        selected: true
                    }).nodes(), function(entry) {
                        return $(entry).data('entry-id')
                    });

                    if (ids.length === 0) {
                        alert('{{ trans('global.datatables.zero_selected') }}')

                        return
                    }

                    if (confirm('{{ trans('global.areYouSure') }}')) {
                        $.ajax({
                                headers: {
                                    'x-csrf-token': _token
                                },
                                method: 'POST',
                                url: config.url,
                                data: {
                                    ids: ids,
                                    _method: 'DELETE'
                                }
                            })
                            .done(function() {
                                location.reload()
                            })
                    }
                }
            }

            let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
            @can('product_delete')
                // dtButtons.push(deleteButton)
            @endcan

            $('.datatable:not(.ajaxTable)').DataTable({
                buttons: dtButtons
            })
        })
    </script>
</x-app-layout>
