<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">User Details</h4>
                        </div>
                        <div class="card-action">
                            <a href="{{ route("admin.users.index") }}" class="btn btn-sm btn-primary" role="button">Back</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="bd-example">
                            <ul class="nav nav-pills" data-toggle="slider-tab" id="myTab" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="account-tab" data-bs-toggle="tab" data-bs-target="#pills-account" type="button" role="tab" aria-controls="account" aria-selected="true">Account</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="deposit-tab" data-bs-toggle="tab" data-bs-target="#pills-deposit" type="button" role="tab" aria-controls="deposit" aria-selected="false">Deposit</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="withdraw-tab" data-bs-toggle="tab" data-bs-target="#pills-withdraw" type="button" role="tab" aria-controls="withdraw" aria-selected="false">Withdraw</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="opentrade-tab" data-bs-toggle="tab" data-bs-target="#pills-opentrade" type="button" role="tab" aria-controls="opentrade" aria-selected="false">Open Trades</button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="closetrade-tab" data-bs-toggle="tab" data-bs-target="#pills-closetrade" type="button" role="tab" aria-controls="closetrade" aria-selected="false">Close Trades</button>
                                </li>
                            </ul>
                            <div class="tab-content" id="pills-tabContent">
                                <div class="tab-pane fade show active" id="pills-account" role="tabpanel" aria-labelledby="pills-account-tab">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="card">
                                                {{-- <div class="card-hearder d-flex justify-content-between"></div> --}}
                                                <div class="card-body px-0">
                                                    <div class="table-responsive">
                                                        <table class="table table-bordered" role="grid" data-toggle="data-table">
                                                            <thead>
                                                                <tr class="light">
                                                                    <th style="text-align: center">Login ID</th>
                                                                    <th style="text-align: center">Client Name</th>
                                                                    <th style="text-align: center">Email</th>
                                                                    <th style="text-align: center">Password</th>
                                                                    <th style="text-align: center">Leverage</th>
                                                                    <th style="text-align: center">Balance</th>
                                                                    <th style="min-width: 100px; text-align:center;">Action</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @foreach ($getuserdata as $key => $product)
                                                                    @if($product && $product->response && in_array($product->response->Login,$getids))
                                                                        <tr>
                                                                            <td class="text-center">
                                                                                <p class="text-xs font-weight-bold mb-0">{{ $product->response->Login ?? '' }}</p>
                                                                            </td>
                                                                            <td class="text-center">
                                                                                <p class="text-xs font-weight-bold mb-0">{{ $product->response->Name ?? '' }}</p>
                                                                            </td>
                                                                            <td class="text-center">
                                                                                <p class="text-xs font-weight-bold mb-0">{{ $product->response->Email ?? '' }}</p>
                                                                            </td>
                                                                            <td class="text-center">
                                                                                <p class="text-xs font-weight-bold mb-0">
                                                                                    <?php $getpass = \App\Models\Mtaccount::where('loginid',$product->response->Login)->first();?>
                                                                                    {{ $getpass->mainpass ?? '' }}
                                                                                </p>
                                                                            </td>
                                                                            <td class="text-center">
                                                                                <p class="text-xs font-weight-bold mb-0">{{ $product->response->Leverage ?? '' }}</p>
                                                                            </td>
                                                                            <td class="text-center">
                                                                                <p class="text-xs font-weight-bold mb-0">{{ $product->response->Balance ?? '' }}</p>
                                                                            </td>
                                                                            <td class="text-center">
                                                                                <div class="flex align-items-center list-user-action">
                                                                                    <a class="btn btn-sm btn-icon btn-primary" data-toggle="tooltip" data-placement="top" title="Add Deposit" data-original-title="Add Deposit"
                                                                                        href="{{ route('admin.users.deposit', $product->response->Login) }}">
                                                                                        <span class="btn-inner">
                                                                                            <svg width="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M21.9964 8.37513H17.7618C15.7911 8.37859 14.1947 9.93514 14.1911 11.8566C14.1884 13.7823 15.7867 15.3458 17.7618 15.3484H22V15.6543C22 19.0136 19.9636 21 16.5173 21H7.48356C4.03644 21 2 19.0136 2 15.6543V8.33786C2 4.97862 4.03644 3 7.48356 3H16.5138C19.96 3 21.9964 4.97862 21.9964 8.33786V8.37513ZM6.73956 8.36733H12.3796H12.3831H12.3902C12.8124 8.36559 13.1538 8.03019 13.152 7.61765C13.1502 7.20598 12.8053 6.87318 12.3831 6.87491H6.73956C6.32 6.87664 5.97956 7.20858 5.97778 7.61852C5.976 8.03019 6.31733 8.36559 6.73956 8.36733Z" fill="currentColor"/>
                                                                                                <path opacity="0.4" d="M16.0374 12.2966C16.2465 13.2478 17.0805 13.917 18.0326 13.8996H21.2825C21.6787 13.8996 22 13.5715 22 13.166V10.6344C21.9991 10.2297 21.6787 9.90077 21.2825 9.8999H17.9561C16.8731 9.90338 15.9983 10.8024 16 11.9102C16 12.0398 16.0128 12.1695 16.0374 12.2966Z" fill="currentColor"/>
                                                                                                <circle cx="18" cy="11.8999" r="1" fill="currentColor"/>
                                                                                            </svg>
                                                                                        </span>
                                                                                    </a>
                                                                                    <a class="btn btn-sm btn-icon btn-primary" data-toggle="tooltip" data-placement="top" title="Withdraw Balance" data-original-title="Withdraw Balance"
                                                                                        href="{{ route('admin.users.withdraw', $product->response->Login) }}">
                                                                                        <span class="btn-inner">
                                                                                            <svg width="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                                                <path opacity="0.4" d="M13.7505 9.70303V7.68318C13.354 7.68318 13.0251 7.36377 13.0251 6.97859V4.57356C13.0251 4.2532 12.764 4.00049 12.4352 4.00049H5.7911C3.70213 4.00049 2 5.653 2 7.68318V10.1155C2 10.3043 2.07737 10.4828 2.21277 10.6143C2.34816 10.7449 2.53191 10.8201 2.72534 10.8201C3.46035 10.8201 4.02128 11.3274 4.02128 11.9944C4.02128 12.6905 3.45068 13.2448 2.73501 13.2533C2.33849 13.2533 2 13.5257 2 13.9203V16.3262C2 18.3555 3.70213 19.9995 5.78143 19.9995H12.4352C12.764 19.9995 13.0251 19.745 13.0251 19.4265V17.3963C13.0251 17.0027 13.354 16.6917 13.7505 16.6917V14.8701C13.354 14.8701 13.0251 14.5497 13.0251 14.1655V10.4076C13.0251 10.0224 13.354 9.70303 13.7505 9.70303Z" fill="currentColor"/>
                                                                                                <path d="M19.9787 11.9948C19.9787 12.69 20.559 13.2443 21.265 13.2537C21.6615 13.2537 22 13.5262 22 13.9113V16.3258C22 18.3559 20.3075 20 18.2186 20H15.0658C14.7466 20 14.4758 19.7454 14.4758 19.426V17.3967C14.4758 17.0022 14.1567 16.6921 13.7505 16.6921V14.8705C14.1567 14.8705 14.4758 14.5502 14.4758 14.1659V10.4081C14.4758 10.022 14.1567 9.70348 13.7505 9.70348V7.6827C14.1567 7.6827 14.4758 7.36328 14.4758 6.9781V4.57401C14.4758 4.25366 14.7466 4 15.0658 4H18.2186C20.3075 4 22 5.64406 22 7.6733V10.0407C22 10.2286 21.9226 10.4081 21.7872 10.5387C21.6518 10.6702 21.4681 10.7453 21.2747 10.7453C20.559 10.7453 19.9787 11.31 19.9787 11.9948Z" fill="currentColor"/>
                                                                                            </svg>
                                                                                        </span>
                                                                                    </a>
                                                                                    <a class="btn btn-sm btn-icon btn-primary" data-toggle="tooltip" data-placement="top" title="Credit In" data-original-title="Credit In"
                                                                                        href="{{ route('admin.users.creditin', $product->response->Login) }}">
                                                                                        <svg width="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                                            <path opacity="0.4" d="M10.8096 8.20248L10.4824 4.50325C10.4824 3.67308 11.1621 3 12.0003 3C12.8386 3 13.5182 3.67308 13.5182 4.50325L13.1911 8.20248C13.1911 8.85375 12.6579 9.38174 12.0003 9.38174C11.3416 9.38174 10.8096 8.85375 10.8096 8.20248Z" fill="currentColor"></path>
                                                                                            <path d="M10.8698 20.6247C10.8115 20.5668 10.5647 20.3508 10.3598 20.1479C9.07656 18.9643 6.97815 15.8738 6.33596 14.2571C6.23352 14.0116 6.01542 13.3909 6 13.0582C6 12.7408 6.0738 12.4375 6.2192 12.1484C6.42299 11.7873 6.74463 11.4993 7.12355 11.34C7.38572 11.2386 8.17331 11.0793 8.18763 11.0793C9.04792 10.9211 10.4469 10.835 11.9934 10.835C13.465 10.835 14.8067 10.9211 15.6813 11.051C15.6967 11.0651 16.6738 11.2244 17.0086 11.3979C17.6211 11.7153 18 12.336 18 13.0004V13.0582C17.9857 13.4913 17.6057 14.4011 17.5924 14.4011C16.9502 15.9316 14.9532 18.949 13.6258 20.1621C13.6258 20.1621 13.2844 20.5047 13.0718 20.653C12.7656 20.8843 12.3866 20.9999 12.0077 20.9999C11.5847 20.9999 11.1915 20.8701 10.8698 20.6247Z" fill="currentColor"></path>
                                                                                        </svg>
                                                                                    </a>
                                                                                    <a class="btn btn-sm btn-icon btn-primary" data-toggle="tooltip" data-placement="top" title="Credit Out" data-original-title="Credit Out"
                                                                                        href="{{ route('admin.users.creditout', $product->response->Login) }}">
                                                                                        <span class="btn-inner">
                                                                                            <svg width="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                                                <path opacity="0.4" d="M13.1904 15.7975L13.5176 19.4967C13.5176 20.3269 12.8379 21 11.9997 21C11.1614 21 10.4818 20.3269 10.4818 19.4967L10.8089 15.7975C10.8089 15.1463 11.3421 14.6183 11.9997 14.6183C12.6584 14.6183 13.1904 15.1463 13.1904 15.7975Z" fill="currentColor"></path>
                                                                                                <path d="M13.1302 3.37534C13.1885 3.43316 13.4353 3.64915 13.6402 3.85206C14.9234 5.03568 17.0218 8.12619 17.664 9.7429C17.7665 9.98835 17.9846 10.6091 18 10.9418C18 11.2592 17.9262 11.5625 17.7808 11.8516C17.577 12.2127 17.2554 12.5007 16.8764 12.66C16.6143 12.7614 15.8267 12.9207 15.8124 12.9207C14.9521 13.0789 13.5531 13.165 12.0066 13.165C10.535 13.165 9.19332 13.0789 8.31871 12.949C8.30329 12.9349 7.32623 12.7756 6.99137 12.6021C6.37892 12.2847 6 11.664 6 10.9996V10.9418C6.01432 10.5087 6.39435 9.5989 6.40756 9.5989C7.04975 8.06837 9.04681 5.05096 10.3742 3.83788C10.3742 3.83788 10.7156 3.49534 10.9282 3.34698C11.2344 3.11571 11.6134 3.00007 11.9923 3.00007C12.4153 3.00007 12.8085 3.12989 13.1302 3.37534Z" fill="currentColor"></path>
                                                                                            </svg>
                                                                                        </span>
                                                                                    </a>
                                                                                    <a class="btn btn-sm btn-icon btn-primary" data-toggle="tooltip" data-placement="top" title="Change Leverage" data-original-title="Change Leverage"
                                                                                        href="{{ route('admin.users.leverage', $product->response->Login) }}">
                                                                                        <span class="btn-inner">
                                                                                            <svg width="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                                                <path d="M12.0122 14.8299C10.4077 14.8299 9.10986 13.5799 9.10986 12.0099C9.10986 10.4399 10.4077 9.17993 12.0122 9.17993C13.6167 9.17993 14.8839 10.4399 14.8839 12.0099C14.8839 13.5799 13.6167 14.8299 12.0122 14.8299Z" fill="currentColor"/>
                                                                                                <path opacity="0.4" d="M21.2301 14.37C21.036 14.07 20.76 13.77 20.4023 13.58C20.1162 13.44 19.9322 13.21 19.7687 12.94C19.2475 12.08 19.5541 10.95 20.4228 10.44C21.4447 9.87 21.7718 8.6 21.179 7.61L20.4943 6.43C19.9118 5.44 18.6344 5.09 17.6226 5.67C16.7233 6.15 15.5685 5.83 15.0473 4.98C14.8838 4.7 14.7918 4.4 14.8122 4.1C14.8429 3.71 14.7203 3.34 14.5363 3.04C14.1582 2.42 13.4735 2 12.7172 2H11.2763C10.5302 2.02 9.84553 2.42 9.4674 3.04C9.27323 3.34 9.16081 3.71 9.18125 4.1C9.20169 4.4 9.10972 4.7 8.9462 4.98C8.425 5.83 7.27019 6.15 6.38109 5.67C5.35913 5.09 4.09191 5.44 3.49917 6.43L2.81446 7.61C2.23194 8.6 2.55897 9.87 3.57071 10.44C4.43937 10.95 4.74596 12.08 4.23498 12.94C4.06125 13.21 3.87729 13.44 3.59115 13.58C3.24368 13.77 2.93709 14.07 2.77358 14.37C2.39546 14.99 2.4159 15.77 2.79402 16.42L3.49917 17.62C3.87729 18.26 4.58245 18.66 5.31825 18.66C5.66572 18.66 6.0745 18.56 6.40153 18.36C6.65702 18.19 6.96361 18.13 7.30085 18.13C8.31259 18.13 9.16081 18.96 9.18125 19.95C9.18125 21.1 10.1215 22 11.3069 22H12.6968C13.872 22 14.8122 21.1 14.8122 19.95C14.8429 18.96 15.6911 18.13 16.7029 18.13C17.0299 18.13 17.3365 18.19 17.6022 18.36C17.9292 18.56 18.3278 18.66 18.6855 18.66C19.411 18.66 20.1162 18.26 20.4943 17.62L21.2097 16.42C21.5776 15.75 21.6083 14.99 21.2301 14.37Z" fill="currentColor"/>
                                                                                            </svg>
                                                                                        </span>
                                                                                    </a>
                                                                                </div>
                                                                            </td>
                                                                        </tr>
                                                                    @endif
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="pills-deposit" role="tabpanel" aria-labelledby="pills-deposit-tab">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="card">
                                                <div class="card-body px-0">
                                                    <div class="table-responsive">
                                                        <table class="table table-bordered" role="grid" data-toggle="data-table">
                                                            <thead>
                                                                <tr class="light">
                                                                    <th style="text-align: center">MT5 Id</th>
                                                                    <th style="text-align: center">Name</th>
                                                                    <th style="text-align: center">Email</th>
                                                                    <th style="text-align: center">Amount</th>
                                                                    <th style="text-align: center">Notes</th>
                                                                    <th style="text-align: center">Admin Response</th>
                                                                    <th style="text-align: center">Date</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @foreach ($deposit as $key => $product)
                                                                    <tr>
                                                                        <td class="text-center">
                                                                            <p class="text-xs font-weight-bold mb-0">{{ $product->mt4account ?? '' }}</p>
                                                                        </td>
                                                                        <td class="text-center">
                                                                            <p class="text-xs font-weight-bold mb-0">{{ $product->name ?? '' }}</p>
                                                                        </td>
                                                                        <td class="text-center">
                                                                            <p class="text-xs font-weight-bold mb-0">{{ $product->email ?? '' }}</p>
                                                                        </td>
                                                                        <td class="text-center">
                                                                            <p class="text-xs font-weight-bold mb-0">{{ $product->amount ?? '' }}</p>
                                                                        </td>
                                                                        <td class="text-center">
                                                                            <p class="text-xs font-weight-bold mb-0">{{ $product->clientnote ?? '' }}</p>
                                                                        </td>
                                                                        <td class="text-center">
                                                                            <p class="text-xs font-weight-bold mb-0">{{ $product->description ?? '' }}</p>
                                                                        </td>
                                                                        <td class="text-center">
                                                                            <p class="text-xs font-weight-bold mb-0">{{ $product->created_at ?? '' }}</p>
                                                                        </td>
                                                                    </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="pills-withdraw" role="tabpanel" aria-labelledby="pills-withdraw-tab">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="card">
                                                <div class="card-body px-0">
                                                    <div class="table-responsive">
                                                        <table class="table table-bordered" role="grid" data-toggle="data-table">
                                                            <thead>
                                                                <tr class="light">
                                                                    <th style="text-align: center">MT5 Id</th>
                                                                    <th style="text-align: center">Name</th>
                                                                    <th style="text-align: center">Email</th>
                                                                    <th style="text-align: center">Amount</th>
                                                                    <th style="text-align: center">Bank Name</th>
                                                                    <th style="text-align: center">Bank Account No.</th>
                                                                    <th style="text-align: center">Swift Code</th>
                                                                    <th style="text-align: center">Notes</th>
                                                                    <th style="text-align: center">Admin Response</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @foreach ($withdraw as $key => $product)
                                                                    <tr>
                                                                        <td class="text-center">
                                                                            <p class="text-xs font-weight-bold mb-0">{{ $product->mt4account ?? '' }}</p>
                                                                        </td>
                                                                        <td class="text-center">
                                                                            <p class="text-xs font-weight-bold mb-0">{{ $product->name ?? '' }}</p>
                                                                        </td>
                                                                        <td class="text-center">
                                                                            <p class="text-xs font-weight-bold mb-0">{{ $product->email ?? '' }}</p>
                                                                        </td>
                                                                        <td class="text-center">
                                                                            <p class="text-xs font-weight-bold mb-0">{{ $product->amount ?? '' }}</p>
                                                                        </td>
                                                                        <td class="text-center">
                                                                            <p class="text-xs font-weight-bold mb-0">{{ $product->bankname ?? '' }}</p>
                                                                        </td>
                                                                        <td class="text-center">
                                                                            <p class="text-xs font-weight-bold mb-0">{{ $product->bankaccount ?? '' }}</p>
                                                                        </td>
                                                                        <td class="text-center">
                                                                            <p class="text-xs font-weight-bold mb-0">{{ $product->swiftcode ?? '' }}</p>
                                                                        </td>
                                                                        <td class="text-center">
                                                                            <p class="text-xs font-weight-bold mb-0">{{ $product->clientnote ?? '' }}</p>
                                                                        </td>
                                                                        <td class="text-center">
                                                                            <p class="text-xs font-weight-bold mb-0">{{ $product->description ?? '' }}</p>
                                                                        </td>
                                                                    </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="pills-opentrade" role="tabpanel" aria-labelledby="pills-opentrade-tab">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="card">
                                                <div class="card-body px-0">
                                                    <div class="table-responsive">
                                                        <table class="table table-bordered" role="grid" data-toggle="data-table">
                                                            <thead>
                                                                <tr class="light">
                                                                    <th style="text-align: center">Login ID</th>
                                                                    <th style="text-align: center">Lot</th>
                                                                    <th style="text-align: center">Open Price</th>
                                                                    <th style="text-align: center">Profit</th>
                                                                    <th style="text-align: center">Swap</th>
                                                                    <th style="text-align: center">Symbol</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @foreach ($positions as $accountId => $accountPositions)
                                                                    @foreach ($accountPositions as $product)
                                                                        <tr data-entry-id="{{ $product->Login }}">
                                                                            <td class="text-center">
                                                                                <p class="text-xs font-weight-bold mb-0">{{ $product->Login ?? '' }}</p>
                                                                            </td>
                                                                            <td class="text-center">
                                                                                <p class="text-xs font-weight-bold mb-0">{{ $product->Volume / 10000 ?? '' }}</p>
                                                                            </td>
                                                                            <td class="text-center">
                                                                                <p class="text-xs font-weight-bold mb-0">{{ $product->PriceOpen ?? '' }}</p>
                                                                            </td>
                                                                            <td class="text-center">
                                                                                <p class="text-xs font-weight-bold mb-0">{{ $product->Profit ?? '' }}</p>
                                                                            </td>
                                                                            <td class="text-center">
                                                                                <p class="text-xs font-weight-bold mb-0">{{ $product->Storage ?? '' }}</p>
                                                                            </td>
                                                                            <td class="text-center">
                                                                                <p class="text-xs font-weight-bold mb-0">{{ $product->Symbol ?? '' }}</p>
                                                                            </td>
                                                                        </tr>
                                                                    @endforeach
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="pills-closetrade" role="tabpanel" aria-labelledby="pills-closetrade-tab">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="card">
                                                <div class="card-body px-0">
                                                    <div class="table-responsive">
                                                        <table class="table table-bordered" role="grid" data-toggle="data-table">
                                                            <thead>
                                                                <tr class="light">
                                                                    <th style="text-align: center">Login ID</th>
                                                                    <th style="text-align: center">Close Price</th>
                                                                    <th style="text-align: center">Lot</th>
                                                                    <th style="text-align: center">Open Price</th>
                                                                    <th style="text-align: center">Symbol</th>
                                                                    <th style="text-align: center">Close Time</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @if(count($closedTrades) > 0)
                                                                    @foreach ($closedTrades as $accountId => $trades)
                                                                        @if(count($trades) > 0)
                                                                            @foreach ($trades as $product)
                                                                                @if($product->PriceCurrent != 0)
                                                                                    <tr data-entry-id="{{ $product->Login }}">
                                                                                        <td class="text-center">
                                                                                            <p class="text-xs font-weight-bold mb-0">{{ $product->Login ?? '' }}</p>
                                                                                        </td>
                                                                                        <td class="text-center">
                                                                                            <p class="text-xs font-weight-bold mb-0">{{ $product->PriceCurrent ?? '' }}</p>
                                                                                        </td>
                                                                                        <td class="text-center">
                                                                                            <p class="text-xs font-weight-bold mb-0">{{ $product->VolumeInitial / 10000 ?? '' }}</p>
                                                                                        </td>
                                                                                        <td class="text-center">
                                                                                            <p class="text-xs font-weight-bold mb-0">{{ $product->PriceOrder ?? '' }}</p>
                                                                                        </td>
                                                                                        <td class="text-center">
                                                                                            <p class="text-xs font-weight-bold mb-0">{{ $product->Symbol ?? '' }}</p>
                                                                                        </td>
                                                                                        <td class="text-center">
                                                                                            <p class="text-xs font-weight-bold mb-0">{{ $product->TimeDone ?? '' }}</p>
                                                                                        </td>
                                                                                    </tr>
                                                                                @endif
                                                                            @endforeach
                                                                        @endif
                                                                    @endforeach
                                                                @endif
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
