<x-app-layout :assets="$assets ?? []">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Leverage Change Request</h4>
                        </div>
                    </div>
                    <div class="card-body px-0">
                        <div class="table-responsive">
                            <table class="table table-bordered" role="grid" data-toggle="data-table">
                                <thead>
                                    <tr class="light">
                                        <th style="text-align: center">Login ID</th>
                                        <th style="text-align: center">Client Name</th>
                                        <th style="text-align: center">Email</th>
                                        <th style="text-align: center">Leverage</th>
                                        <th style="text-align: center">Status</th>
                                        <th style="min-width: 100px; text-align:center;">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($accounts as $key => $product)
                                        <tr data-entry-id="{{ $product->id }}">
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->mtaccount ?? '' }}
                                                </p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->name ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->email ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->leverage ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">
                                                    @if($product->status == '0')
                                                        <a class="btn btn-sm btn-icon btn-info" href="#">
                                                            Pending
                                                        </a>
                                                    @elseif($product->status == '1')
                                                        <a class="btn btn-sm btn-icon btn-success" href="#">
                                                            Approved
                                                        </a>
                                                    @elseif($product->status == '2')
                                                        <a class="btn btn-sm btn-icon btn-danger" href="#">
                                                            Rejected
                                                        </a>
                                                    @endif
                                                </p>
                                            </td>
                                            <td class="text-center">
                                                @if($checkadmin == true && Auth::user()->affiliate != '1')
                                                    @if($product->status == '0' || $product->status == '2')
                                                        <a class="btn btn-sm btn-icon btn-success" href="{{url('admin/editleverage/'.$product->id)}}">
                                                            Approve
                                                        </a>
                                                    @elseif($product->status == '1')
                                                        <a class="btn btn-sm btn-icon btn-info disabled" href="#">
                                                            Approved
                                                        </a>
                                                    @endif
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        $(function() {
            let deleteButtonTrans = '{{ trans('global.datatables.delete') }}'
            let deleteButton = {
                text: deleteButtonTrans,
                url: "{{ route('admin.products.massDestroy') }}",
                className: 'btn-danger',
                action: function(e, dt, node, config) {
                    var ids = $.map(dt.rows({
                        selected: true
                    }).nodes(), function(entry) {
                        return $(entry).data('entry-id')
                    });

                    if (ids.length === 0) {
                        alert('{{ trans('global.datatables.zero_selected') }}')

                        return
                    }

                    if (confirm('{{ trans('global.areYouSure') }}')) {
                        $.ajax({
                                headers: {
                                    'x-csrf-token': _token
                                },
                                method: 'POST',
                                url: config.url,
                                data: {
                                    ids: ids,
                                    _method: 'DELETE'
                                }
                            })
                            .done(function() {
                                location.reload()
                            })
                    }
                }
            }
            let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
            @can('product_delete')
                // dtButtons.push(deleteButton)
            @endcan

            $('.datatable:not(.ajaxTable)').DataTable({
                'iDisplayLength': 600,
                buttons: dtButtons
            })
        })
    </script>
</x-app-layout>
