<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Assign Affiliate to Subadmin</h4>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route("admin.users.storesub") }}" method="POST" role="form text-left" class="needs-validation" enctype="multipart/form-data">
                            @csrf
                            <div class="new-user-info">
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="subadmin">Select Subadmin: <span class="text-danger">*</span></label>
                                        <select class="form-control" name="subadmin" id="subadmin" >
                                            <option value="">Select Subadmin</option>
                                            @if (count($subadmins) > 0)
                                                @foreach ($subadmins as $affiliate)
                                                    <option value="{{ $affiliate->id }}">{{ $affiliate->name }}({{ $affiliate->email }})
                                                    </option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="afid">Select Affiliate: <span class="text-danger">*</span></label>
                                        <select class="form-control" name="afid" id="afid" >
                                            <option value="">Select Affiliate</option>
                                            @if(count($affiliates)>0)
                                                @foreach($affiliates as $affiliate)
                                                    <option value="{{ $affiliate->id }}">{{ $affiliate->name }}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-sm btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <div class="header-title">
                    <h4 class="card-title">Assigned Subadmin List</h4>
                </div>
            </div>
            <div class="card-body px-0">
                <div class="table-responsive">
                    <table class="table table-bordered" role="grid" data-toggle="data-table">
                        <thead>
                        <tr class="ligth">
                            <th width="10"></th>
                            <th style="text-align: center">ID</th>
                            <th style="text-align: center">Name</th>
                            <th style="text-align: center">Email</th>
                            <th style="text-align: center">Subadmin Name</th>
                        </tr>
                        </thead>
                        <tbody>
                            @foreach ($affiliatenames as $key => $user)
                                <tr data-entry-id="{{ $user->id }}">
                                    <td><input type="checkbox" name="bulk-select" class="user-checkbox"></td>
                                    <td class="text-center">
                                        <p class="text-xs font-weight-bold mb-0">{{ $user->id ?? '' }}</p>
                                    </td>
                                    <td class="text-center">
                                        <p class="text-xs font-weight-bold mb-0">{{ $user->name ?? '' }}</p>
                                    </td>
                                    <td class="text-center">
                                        <p class="text-xs font-weight-bold mb-0">{{ $user->email ?? '' }}</p>
                                    </td>
                                    <td class="text-center">
                                        <p class="text-xs font-weight-bold mb-0">
                                            <?php
                                                $getname = \App\Models\User::select('name')
                                                    ->where('id', $user->afid)
                                                    ->first();
                                                if (!empty($getname)) {
                                                    echo $getname->name;
                                                }
                                            ?>
                                        </p>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
