var VENDOR_PREFIX = [
    'webkit',
    'moz',
    'ms',
    'o',
];
var RE = new RegExp("^-(?!(?:" + VENDOR_PREFIX.join('|') + ")-)");
function autoPrefix(styles) {
    var res = {};
    Object.keys(styles).forEach(function (prop) {
        if (!RE.test(prop)) {
            res[prop] = styles[prop];
            return;
        }
        var val = styles[prop];
        prop = prop.replace(/^-/, '');
        res[prop] = val;
        VENDOR_PREFIX.forEach(function (prefix) {
            res["-" + prefix + "-" + prop] = val;
        });
    });
    return res;
}
export function setStyle(elem, styles) {
    styles = autoPrefix(styles);
    Object.keys(styles).forEach(function (prop) {
        var cssProp = prop.replace(/^-/, '').replace(/-([a-z])/g, function (_, $1) { return $1.toUpperCase(); });
        elem.style[cssProp] = styles[prop];
    });
}
//# sourceMappingURL=set-style.js.map