<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Leverage Change Request</h4>
                        </div>
                        <div class="card-action">
                            <a href="{{ route("admin.leverage") }}" class="btn btn-sm btn-primary" role="button">Back</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route("admin.leveragestore") }}" method="POST" role="form text-left" class="needs-validation" enctype="multipart/form-data">
                            @csrf
                            <div class="new-user-info">
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="mtaccount">Select Account <span class="text-danger">*</span></label>
                                        <select class="form-control" name="mtaccount" id="mtaccount">
                                            @if(count($accounts)>0)
                                                @foreach($accounts as $account)
                                                    <option value="{{$account->loginid}}">{{$account->loginid}}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="leverage">Select Leverage</label>
                                        <select class="form-control" name="leverage" id="leverage">
                                            <option value="100">1:100</option>
                                            <option value="200">1:200</option>
                                            <option value="300">1:300</option>
                                            <option value="400">1:400</option>
                                        </select>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-sm btn-primary">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
