<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve(['assets' => $assets ?? []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <form id="account-form" action="<?php echo e(url('admin/client/openposition')); ?>" method="GET">
                        <?php echo csrf_field(); ?>
                        <div class="row" style="margin-left: 15px; margin-top: 10px;">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="form-label" for="account">Select Account</label>
                                    <select class="form-control" name="account" id="account">
                                        <?php if(count($accounts) > 0): ?>
                                            <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($account->loginid); ?>" <?php echo e($mtaccount == $account->loginid ? 'selected' : ''); ?>>
                                                    <?php echo e($account->loginid); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <input class="btn btn-sm btn-success" type="submit" value="Submit" style="margin-top:37px;">
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">Open Positions</h4>
                        </div>
                    </div>
                    <div class="card-body px-0">
                        <div class="table-responsive">
                            <table class="table table-bordered" role="grid" id="positions-table" data-toggle="data-table">
                                <thead>
                                    <tr class="light">
                                        <th style="text-align: center">Login ID</th>
                                        <th style="text-align: center">Lot</th>
                                        <th style="text-align: center">Open Price</th>
                                        <th style="text-align: center">Profit</th>
                                        <th style="text-align: center">Swap</th>
                                        <th style="text-align: center">Symbol</th>
                                    </tr>
                                </thead>
                                <tbody id="positions-body">
                                    <?php $__currentLoopData = $positions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $position): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr data-entry-id="<?php echo e($position->Login); ?>">
                                            <td class="text-center"><?php echo e($position->Login ?? ''); ?></td>
                                            <td class="text-center"><?php echo e($position->Volume / 10000 ?? ''); ?></td>
                                            <td class="text-center"><?php echo e($position->PriceOpen ?? ''); ?></td>
                                            <td class="text-center"><?php echo e($position->Profit ?? ''); ?></td>
                                            <td class="text-center"><?php echo e($position->Storage ?? ''); ?></td>
                                            <td class="text-center"><?php echo e($position->Symbol ?? ''); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(function() {
            let deleteButtonTrans = '<?php echo e(trans('global.datatables.delete')); ?>'
            let deleteButton = {
                text: deleteButtonTrans,
                url: "<?php echo e(route('admin.products.massDestroy')); ?>",
                className: 'btn-danger',
                action: function(e, dt, node, config) {
                    var ids = $.map(dt.rows({
                        selected: true
                    }).nodes(), function(entry) {
                        return $(entry).data('entry-id')
                    });

                    if (ids.length === 0) {
                        alert('<?php echo e(trans('global.datatables.zero_selected')); ?>')

                        return
                    }

                    if (confirm('<?php echo e(trans('global.areYouSure')); ?>')) {
                        $.ajax({
                                headers: {
                                    'x-csrf-token': _token
                                },
                                method: 'POST',
                                url: config.url,
                                data: {
                                    ids: ids,
                                    _method: 'DELETE'
                                }
                            })
                            .done(function() {
                                location.reload()
                            })
                    }
                }
            }

            let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_delete')): ?>
                // dtButtons.push(deleteButton)
            <?php endif; ?>

            $('.datatable:not(.ajaxTable)').DataTable({
                buttons: dtButtons
            })
        })

        $(document).ready(function () {
            function fetchPositions() {
                const account = $('#account').val();

                $.ajax({
                    url: "<?php echo e(url('admin/client/openposition')); ?>",
                    method: 'GET',
                    data: {
                        account: account,
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    success: function (response) {
                        updateTable(response.positions);
                    },
                    error: function (error) {
                        console.error('Error fetching positions:', error);
                    }
                });
            }

            function updateTable(positions) {
                let tableBody = '';

                if (positions.length > 0) {
                    positions.forEach((position) => {
                        tableBody += `
                            <tr data-entry-id="${position.Login}">
                                <td class="text-center">${position.Login ?? ''}</td>
                                <td class="text-center">${position.Volume / 10000 ?? ''}</td>
                                <td class="text-center">${position.PriceOpen ?? ''}</td>
                                <td class="text-center">${position.Profit ?? ''}</td>
                                <td class="text-center">${position.Storage ?? ''}</td>
                                <td class="text-center">${position.Symbol ?? ''}</td>
                            </tr>
                        `;
                    });
                } else {
                    tableBody = `<tr><td colspan="6" class="text-center">No data available in table</td></tr>`;
                }

                $('#positions-body').html(tableBody);
            }

            setInterval(fetchPositions, 10000);

            fetchPositions();

            $('#account').change(fetchPositions);
        });
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /home/fxdemosi/public_html/crm.fxdemo.site/resources/views/admin/mtaccount/clientopen.blade.php ENDPATH**/ ?>