<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Leads;
use App\Models\Leadstatus;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Gate;

class LeadstatusController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $leadstatus = Leadstatus::all();
        return view('admin.leadstatus.index', compact('leadstatus'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.leadstatus.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $leadstatus = new Leadstatus();
        $leadstatus->name = $request->input('leadname');
        // echo '<pre>';print_r($leadstatus);exit;

        $leadstatus->save();

        return redirect()->route('admin.leadstatus.index')->with('success','Lead Status added successfully');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $leadstatus = Leadstatus::findOrFail($id);

        return view('admin.leadstatus.edit', compact('leadstatus'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $leadstatus = Leadstatus::findOrFail($id);
        $leadstatus->name = $request->input('leadname');
        // echo '<pre>';print_r($leadstatus);exit;

        $leadstatus->save();

        return redirect()->route('admin.leadstatus.index')->with('success','Lead Status updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $leadstatus = Leadstatus::findOrFail($id);
        $leadstatus->delete();

        return redirect()->route('admin.leadstatus.index')->with('success','Lead Status deleted successfully');
    }

    public function ftdStatus()
    {
        $checkadmin = Gate::allows('permission_create');
        if ($checkadmin == true) {
            $accounts =  Leads::orderBy('id', 'DESC')->where('status','FTD')->get();
        } elseif ($checkadmin == false && Auth::user()->affiliate == '1') {
            $accounts = Leads::where('leadowner', Auth::user()->id)->where('status','FTD')->orderBy('id', 'DESC')->get();
        } elseif ($checkadmin == false && Auth::user()->issubadmin == '1') {
            $accounts = Leads::where('leadowner', Auth::user()->id)->where('status','FTD')->orderBy('id', 'DESC')->get();
        } else {
            abort(403);
        }

        if (Auth::user()->affiliate == '1' && Auth::user()->issubadmin == '1') {
            $getafids = User::select('id')->where('afid', Auth::user()->id)->pluck('id')->toArray();
            $afids = array_merge($getafids, $getafids);
            $accounts = Leads::whereIn('leadowner', $afids)->where('status','FTD')->orderBy('id', 'DESC')->get();
        }
        return view('admin.leadstatus.ftdStatus', compact('accounts'));
    }

    public function callbackStatus()
    {
        $checkadmin = Gate::allows('permission_create');
        if ($checkadmin == true) {
            $accounts =  Leads::orderBy('id', 'DESC')->where('status','Callback')->get();
        } elseif ($checkadmin == false && Auth::user()->affiliate == '1') {
            $accounts = Leads::where('leadowner', Auth::user()->id)->where('status','Callback')->orderBy('id', 'DESC')->get();
        } elseif ($checkadmin == false && Auth::user()->issubadmin == '1') {
            $accounts = Leads::where('leadowner', Auth::user()->id)->where('status','Callback')->orderBy('id', 'DESC')->get();
        } else {
            abort(403);
        }

        if (Auth::user()->affiliate == '1' && Auth::user()->issubadmin == '1') {
            $getafids = User::select('id')->where('afid', Auth::user()->id)->pluck('id')->toArray();
            $afids = array_merge($getafids, $getafids);
            $accounts = Leads::whereIn('leadowner', $afids)->where('status','Callback')->orderBy('id', 'DESC')->get();
        }
        return view('admin.leadstatus.callbackStatus', compact('accounts'));
    }

    public function confirmedStatus()
    {
        $checkadmin = Gate::allows('permission_create');
        if ($checkadmin == true) {
            $accounts =  Leads::orderBy('id', 'DESC')->where('status','Confirmed')->get();
        } elseif ($checkadmin == false && Auth::user()->affiliate == '1') {
            $accounts = Leads::where('leadowner', Auth::user()->id)->where('status','Confirmed')->orderBy('id', 'DESC')->get();
        } elseif ($checkadmin == false && Auth::user()->issubadmin == '1') {
            $accounts = Leads::where('leadowner', Auth::user()->id)->where('status','Confirmed')->orderBy('id', 'DESC')->get();
        } else {
            abort(403);
        }

        if (Auth::user()->affiliate == '1' && Auth::user()->issubadmin == '1') {
            $getafids = User::select('id')->where('afid', Auth::user()->id)->pluck('id')->toArray();
            $afids = array_merge($getafids, $getafids);
            $accounts = Leads::whereIn('leadowner', $afids)->where('status','Confirmed')->orderBy('id', 'DESC')->get();
        }
        return view('admin.leadstatus.confirmedStatus', compact('accounts'));
    }

    public function hotStatus()
    {
        $checkadmin = Gate::allows('permission_create');
        if ($checkadmin == true) {
            $accounts =  Leads::orderBy('id', 'DESC')->where('status','Hot')->get();
        } elseif ($checkadmin == false && Auth::user()->affiliate == '1') {
            $accounts = Leads::where('leadowner', Auth::user()->id)->where('status','Hot')->orderBy('id', 'DESC')->get();
        } elseif ($checkadmin == false && Auth::user()->issubadmin == '1') {
            $accounts = Leads::where('leadowner', Auth::user()->id)->where('status','Hot')->orderBy('id', 'DESC')->get();
        } else {
            abort(403);
        }

        if (Auth::user()->affiliate == '1' && Auth::user()->issubadmin == '1') {
            $getafids = User::select('id')->where('afid', Auth::user()->id)->pluck('id')->toArray();
            $afids = array_merge($getafids, $getafids);
            $accounts = Leads::whereIn('leadowner', $afids)->where('status','Hot')->orderBy('id', 'DESC')->get();
        }
        return view('admin.leadstatus.hotStatus', compact('accounts'));
    }
}
