<x-app-layout :assets="$assets ?? []">
    <div>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <div class="header-title">
                            <h4 class="card-title">FTD Leads</h4>
                        </div>
                    </div>
                    <div class="card-body px-0">
                        <div class="table-responsive">
                            <table class="table table-bordered" role="grid" data-toggle="data-table">
                                <thead>
                                    <tr class="ligth">
                                        <th width="10"></th>
                                        <th style="text-align: center">Lead No.</th>
                                        <th style="text-align: center">First Name</th>
                                        <th style="text-align: center">Last Name</th>
                                        <th style="text-align: center">Email</th>
                                        <th style="text-align: center;">Country</th>
                                        <th style="text-align: center;">Mobile</th>
                                        <th style="text-align: center;">Lead Owner</th>
                                        <th style="text-align: center;">Comment</th>
                                        <th style="text-align: center;">Source</th>
                                        <th style="text-align: center;">Source URL</th>
                                        <th style="text-align: center;">Status</th>
                                        <th style="text-align: center;">Date</th>
                                        <th style="text-align: center;">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($accounts as $key => $product)
                                        <tr data-entry-id="{{ $product->id }}">
                                            <td><input type="checkbox" name="bulk-select" class="user-checkbox"></td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->id ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->firstname ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->lastname ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->email ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->country ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->mobile ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">
                                                    <?php
                                                        $owner = \App\Models\User::select('name')
                                                            ->where('id', $product->leadowner)
                                                            ->first();
                                                        if (!empty($owner)) {
                                                            echo $owner->name;
                                                        }
                                                    ?>
                                                </p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->note ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->source ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->sourceurl ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->status ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $product->created_at ?? '' }}</p>
                                            </td>
                                            <td class="text-center">
                                                <div class="flex align-items-center list-user-action">
                                                    <a class="btn btn-sm btn-icon btn-primary" data-toggle="tooltip"
                                                        data-placement="top" title="" data-original-title="Edit"
                                                        href="{{ url('admin/editleads/' . $product->id) }}">
                                                        <span class="btn-inner">
                                                            <svg width="20" viewBox="0 0 24 24" fill="none"
                                                                xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="M11.4925 2.78906H7.75349C4.67849 2.78906 2.75049 4.96606 2.75049 8.04806V16.3621C2.75049 19.4441 4.66949 21.6211 7.75349 21.6211H16.5775C19.6625 21.6211 21.5815 19.4441 21.5815 16.3621V12.3341"
                                                                    stroke="currentColor" stroke-width="1.5"
                                                                    stroke-linecap="round" stroke-linejoin="round">
                                                                </path>
                                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                                    d="M8.82812 10.921L16.3011 3.44799C17.2321 2.51799 18.7411 2.51799 19.6721 3.44799L20.8891 4.66499C21.8201 5.59599 21.8201 7.10599 20.8891 8.03599L13.3801 15.545C12.9731 15.952 12.4211 16.181 11.8451 16.181H8.09912L8.19312 12.401C8.20712 11.845 8.43412 11.315 8.82812 10.921Z"
                                                                    stroke="currentColor" stroke-width="1.5"
                                                                    stroke-linecap="round" stroke-linejoin="round">
                                                                </path>
                                                                <path d="M15.1655 4.60254L19.7315 9.16854"
                                                                    stroke="currentColor" stroke-width="1.5"
                                                                    stroke-linecap="round" stroke-linejoin="round">
                                                                </path>
                                                            </svg>
                                                        </span>
                                                    </a>
                                                    <a class="btn btn-sm btn-icon btn-success" data-toggle="tooltip" data-placement="top" title="" data-original-title="Show" href="{{ url('admin/leadhist/' . $product->id) }}">
                                                        <span class="btn-inner">
                                                            <div id="dual-svg-container-101">
                                                                <svg width="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                    <path d="M22.4541 11.3918C22.7819 11.7385 22.7819 12.2615 22.4541 12.6082C21.0124 14.1335 16.8768 18 12 18C7.12317 18 2.98759 14.1335 1.54586 12.6082C1.21811 12.2615 1.21811 11.7385 1.54586 11.3918C2.98759 9.86647 7.12317 6 12 6C16.8768 6 21.0124 9.86647 22.4541 11.3918Z" fill="#130F26" fill-opacity="0.4" stroke="#130F26"/>
                                                                    <circle cx="12" cy="12" r="5" stroke="#130F26"/>
                                                                    <circle cx="12" cy="12" r="3" fill="#130F26"/>
                                                                    <mask mask-type="alpha" maskUnits="userSpaceOnUse" x="9" y="9" width="6" height="6">
                                                                    <circle cx="12" cy="12" r="3" fill="#130F26"/>
                                                                    </mask>
                                                                    <circle opacity="0.53" cx="13.5" cy="10.5" r="1.5" fill="white"/>
                                                                </svg>
                                                            </div>
                                                        </span>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(function () {
            let deleteButtonTrans = 'Bulk Assign'
            let deleteButton = {
                text: deleteButtonTrans,
                url: "{{ route('admin.leadsbulk') }}",
                className: 'btn-success',
                action: function (e, dt, node, config) {
                    var ids = $.map(dt.rows({ selected: true }).nodes(), function (entry) {
                        return $(entry).data('entry-id')
                    });

                    if (ids.length === 0) {
                        alert('{{ trans('global.datatables.zero_selected') }}')

                        return
                    }

                    if (confirm('{{ trans('global.areYouSure') }}')) {
                        var encode = btoa(ids);
                        var weburl = '/admin/leadsbulk/' + encode;
                        location.href = weburl;
                        // $.ajax({
                        // headers: {'x-csrf-token': _token},
                        // method: 'POST',
                        // url: config.url,
                        // data: { ids: ids, _method: 'DELETE' }})
                        // .done(function () { location.reload() })
                    }
                }
            }
            let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
            @can('product_delete')
            dtButtons.push(deleteButton)
            @endcan

            $('.datatable:not(.ajaxTable)').DataTable({ buttons: dtButtons })
        })
    </script>
</x-app-layout>
